/* 0irc
 * Copyright (C) 2000-2001 Torsten Stelling <murphy@dev0.de>
 *
 * AuroreIRC
 * Copyright (C) 1999 Omar Kilani <omar@aurore.net>
 *
 * OpenIRC
 * Copyright (C) 1998 Damian Hodgkiss <mian@thrity4.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdarg.h>
#include <stdio.h>
#include "irc.h"
#include "style.h"

char *get_args(char *buf, int num, BOOL all)
{
	static char sbuf[1024];
	char *p1, *p2;
	BOOL found = FALSE;
	int cnum = 0;

	ZeroMemory(&sbuf, sizeof(sbuf));
	p1 = buf;
	p2 = sbuf;
	while (*p1 && cnum < num)
	{
		if (*p1 == ' ') cnum++;
		p1++;
	}
	while (*p1)
	{
		if (*p1 == ' ' && !all) break;
		*p2 = *p1;
		p1++;
		p2++;
	}

	p2 = sbuf;
	return (char *)p2;
}

char *cvt_style(char *style, const char *format, ...)
{
	static char buf[8192], sbuf[8192], temp[1024];
	char *ret, *ptr, *sptr = NULL;
	va_list args;
	int i;

	for (i = 0; styles[i].identifier; i++)
	{
		if (!strcmpi(styles[i].identifier, style)) sptr = styles[i].data;
	}
	if (!sptr) return (char *)"";
	ZeroMemory(&sbuf, sizeof(sbuf));
	ZeroMemory(&buf, sizeof(buf));
	va_start(args, format);
	_vsnprintf(buf, sizeof(buf), format, args);
	va_end(args);

	ptr = sbuf;
	for (i = 0; i < lstrlen(sptr); i++)
	{
		if (sptr[i] == '$')
		{
			i++;
			if (isdigit(sptr[i]))
			{
				int num = sptr[i] - 48;
				BOOL all = FALSE;

				if (sptr[i+1] == '-')
				{
					all = TRUE;
					i++;
				}
				strncpy(temp, get_args(buf, num, all), sizeof(temp));
				strcat(ptr, temp);
				ptr += lstrlen(temp);
			} else {
				switch(toupper(sptr[i]))
				{
					case 'G': strcat(ptr, header); ptr += lstrlen(header); break;
				}
			}
		} else {
			*ptr = sptr[i];
			ptr++;
		}
	}

	ret = sbuf;
	return (char *)ret;
}