/* 0irc
 * Copyright (C) 2000-2001 Torsten Stelling <murphy@dev0.de>
 *
 * AuroreIRC
 * Copyright (C) 1999 Omar Kilani <omar@aurore.net>
 *
 * OpenIRC
 * Copyright (C) 1998 Damian Hodgkiss <mian@thrity4.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include "commands.h"
#include "irc.h"
#include "resource.h"
#include <shlobj.h>
//#include "constants.h"

int CALLBACK BrowseCallbackProc(HWND, UINT, LPARAM, LPARAM);
BOOL BrowseForFolder(HWND hwnd, LPCSTR lpszRoot, LPCSTR lpszDefault, LPSTR lpszBuffer);

BOOL APIENTRY Cfg_Server(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	static PROPSHEETPAGE *ps;
	switch (uMsg)
	{
		case WM_INITDIALOG:
			{
				ps = (PROPSHEETPAGE *) lParam;

				SetDlgItemText(hWnd, IDC_SERVER_NICK, cfg.nick);
				SetDlgItemText(hWnd, IDC_SERVER_NICK2, cfg.nick2);
				SetDlgItemText(hWnd, IDC_SERVER_USERNAME, cfg.username);
				SetDlgItemText(hWnd, IDC_SERVER_IRCNAME, cfg.desc);	
				SetDlgItemText(hWnd, IDC_SERVER_LIST, cfg.server);
				return 1;
			}
			break;

		case WM_NOTIFY:
			switch(((NMHDR FAR *) lParam)->code)
			{
				case PSN_APPLY:
					{
						GetDlgItemText(hWnd, IDC_SERVER_NICK, (char *)cfg.nick, sizeof(cfg.nick));
						GetDlgItemText(hWnd, IDC_SERVER_NICK2, (char *)cfg.nick2, sizeof(cfg.nick2));
						GetDlgItemText(hWnd, IDC_SERVER_USERNAME, (char *)cfg.username, sizeof(cfg.username));
						GetDlgItemText(hWnd, IDC_SERVER_IRCNAME, (char *)cfg.desc, sizeof(cfg.desc));
						GetDlgItemText(hWnd, IDC_SERVER_LIST, (char *)cfg.server, sizeof(cfg.server));
						SaveConfig(ircconfig);
					}
					break;

				case PSN_KILLACTIVE:
					SetWindowLong(hWnd, DWL_MSGRESULT, FALSE);
					return 1;
					break;
			}
			break;
	}
	return 0;
}

BOOL APIENTRY Cfg_DCC(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	static PROPSHEETPAGE *ps;
	switch (uMsg)
	{
		case WM_INITDIALOG:
			{
				char temp[10];
				ps = (PROPSHEETPAGE *) lParam;
				
				if (!cfg.dccOverrideHost[0])
				{
					char localhost[256];

					if (!gethostname((char *)localhost, sizeof(localhost)))
					{
						if (inet_addr(localhost) == INADDR_NONE)
						{
							struct hostent *hp = gethostbyname(localhost);
							if (hp != NULL)
							{
								struct sockaddr_in sin;
								memcpy(&sin.sin_addr, hp->h_addr_list[0], sizeof(DWORD));
								strcpy(cfg.dccOverrideHost, inet_ntoa(sin.sin_addr));
							}
						}
					}
				}

				SetDlgItemText(hWnd, IDC_DCC_RECEIVE, cfg.dccReceivePath);
				SetDlgItemText(hWnd, IDC_DCC_LOCALHOST, cfg.dccOverrideHost);
				CheckDlgButton(hWnd, IDC_DCC_OVERRIDELOCAL, cfg.dccOverrideLocalhost);
				wsprintf(temp, "%d k", cfg.dccBlockSize);
				SetDlgItemText(hWnd, IDC_DCC_BLOCKSIZE, temp);
				SendDlgItemMessage(hWnd, IDC_DCC_SLIDER, TBM_SETRANGE, TRUE, MAKELONG(512,4096));
				SendDlgItemMessage(hWnd, IDC_DCC_SLIDER, TBM_SETRANGEMIN, TRUE, 512);
				SendDlgItemMessage(hWnd, IDC_DCC_SLIDER, TBM_SETRANGEMAX, TRUE, 4096);
				
				return 1;
			}
			break;

		case WM_NOTIFY:
			switch(((NMHDR FAR *) lParam)->code)
			{
				case PSN_APPLY:
					{
						GetDlgItemText(hWnd, IDC_DCC_RECEIVE, (char *)cfg.dccReceivePath, sizeof(cfg.dccReceivePath));
						GetDlgItemText(hWnd, IDC_DCC_LOCALHOST, (char *)cfg.dccOverrideHost, sizeof(cfg.dccOverrideHost));
						cfg.dccOverrideLocalhost = IsDlgButtonChecked(hWnd, IDC_DCC_OVERRIDELOCAL);
						cfg.dccBlockSize = GetDlgItemInt(hWnd, IDC_DCC_BLOCKSIZE, NULL, FALSE);
						SaveConfig(ircconfig);
					}
					break;

				case PSN_KILLACTIVE:
					SetWindowLong(hWnd, DWL_MSGRESULT, FALSE);
					return 1;
					break;
			}
			break;
		case WM_COMMAND:
			{
				char buf[] = "";
				if (wParam == IDC_DCC_RECEIVE_BROWSE)
				{
					
					BrowseForFolder(hWnd, "My Computer", "0irc", buf);
					SetDlgItemText(hWnd, IDC_DCC_RECEIVE, buf);

				}
				break;
			}
	}
	return 0;
}

BOOL APIENTRY Cfg_Display(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	static PROPSHEETPAGE *ps;
	switch (uMsg)
	{
		case WM_USER+0x1998:
			{
				int i;

				SendDlgItemMessage(hWnd, IDC_DISPLAY_LIST, LB_RESETCONTENT, 0, 0);
				for (i = 0; styles[i].identifier; i++)
				{
					char *temp = (char *)malloc(strlen(styles[i].identifier) + strlen(styles[i].data) +5);

					wsprintf(temp, "[%s] %s", styles[i].identifier, styles[i].data);
					SendDlgItemMessage(hWnd, IDC_DISPLAY_LIST, LB_INSERTSTRING, -1, (LPARAM)temp);
					free(temp);
					SetDlgItemText(hWnd, IDC_DISPLAY_STYLE_EDIT, "");
				}
			}
			break;

		case WM_INITDIALOG:
			{
				ps = (PROPSHEETPAGE *) lParam;
				SendMessage(hWnd, WM_USER+0x1998, 0, 0);
				return 1;
			}
			break;

		case WM_COMMAND:
			{
				if (wParam == IDC_DISPLAY_STYLE_LOAD)
				{
					OPENFILENAME ofn;
					char file[MAX_PATHLEN];

					ZeroMemory(&file, sizeof(file));
					ZeroMemory(&ofn, sizeof(ofn));
					ofn.lStructSize = sizeof(ofn);
					ofn.hwndOwner = hMainWnd;
					ofn.hInstance = g_hInst;
					ofn.lpstrFilter = "0irc Style (*.sty)\0*.sty\0";
					ofn.nFilterIndex = 1;
					ofn.lpstrFile = file;
					ofn.nMaxFile = sizeof(file);
					ofn.lpstrFileTitle = NULL;
					ofn.nMaxFileTitle = 0;
					ofn.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST;
					if (GetOpenFileName(&ofn))
					{
						Style(ofn.lpstrFile);
						SendMessage(hWnd, WM_USER+0x1998, 0, 0);
					}
				} else
				if (wParam == IDC_DISPLAY_STYLE_SAVE)
				{
					OPENFILENAME ofn;
					char file[MAX_PATHLEN];

					ZeroMemory(&file, sizeof(file));
					ZeroMemory(&ofn, sizeof(ofn));
					ofn.lStructSize = sizeof(ofn);
					ofn.hwndOwner = hMainWnd;
					ofn.hInstance = g_hInst;
					ofn.lpstrFilter = "0irc Style (*.sty)\0*.sty\0";
					ofn.nFilterIndex = 1;
					ofn.lpstrFile = file;
					ofn.nMaxFile = sizeof(file);
					ofn.lpstrFileTitle = NULL;
					ofn.nMaxFileTitle = 0;
					ofn.lpstrDefExt = "sty";
					ofn.Flags = OFN_PATHMUSTEXIST;
					if (GetSaveFileName(&ofn))
					{
						HANDLE hf;
						int num, i;
//						strcat(file,".sty");
						hf = CreateFile(file, GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_ALWAYS,
							FILE_ATTRIBUTE_NORMAL, NULL);
						for (i = 0; styles[i].identifier; i++)
						{
							WriteFile(hf, "set ", 4, &num, NULL);
							WriteFile(hf, styles[i].identifier, lstrlen(styles[i].identifier), &num, NULL);
							WriteFile(hf, " ", 1, &num, NULL);
							WriteFile(hf, styles[i].data, lstrlen(styles[i].data), &num, NULL);
							WriteFile(hf, "\n", 1, &num, NULL);
						}
						CloseHandle(hf);
					}
				} else
				if (HIWORD(wParam) == LBN_SELCHANGE)
				{
					int num = SendDlgItemMessage(hWnd, IDC_DISPLAY_LIST, LB_GETCURSEL, 0, 0);

					if (num != LB_ERR)
					{
						SetDlgItemText(hWnd, IDC_DISPLAY_STYLE_EDIT, styles[num].data);
					}
				}
			}
			break;

		case WM_NOTIFY:
			switch(((NMHDR FAR *) lParam)->code)
			{
				case PSN_APPLY:
					{
					}
					break;

				case PSN_KILLACTIVE:
					SetWindowLong(hWnd, DWL_MSGRESULT, FALSE);
					return 1;
					break;
			}
			break;
	}
	return 0;
}

//BOOL APIENTRY Cfg_Speech(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
//{
//	static PROPSHEETPAGE *ps;
//	switch (uMsg)
//	{
//		case WM_INITDIALOG:
//			{
//				ps = (PROPSHEETPAGE *) lParam;
//				CheckDlgButton(hWnd, IDC_SPEECH_PUBLIC, cfg.speechPublic);
//				CheckDlgButton(hWnd, IDC_SPEECH_ACTION, cfg.speechAction);
//				CheckDlgButton(hWnd, IDC_SPEECH_PRIVATE, cfg.speechPrivate);
//				CheckDlgButton(hWnd, IDC_SPEECH_CTCP, cfg.speechCtcp);
//				CheckDlgButton(hWnd, IDC_SPEECH_NOTIFYSIGNON, cfg.speechNotifyOn);
//				CheckDlgButton(hWnd, IDC_SPEECH_NOTIFYSIGNOFF, cfg.speechNotifyOff);
//				CheckDlgButton(hWnd, IDC_SPEECH_JOIN, cfg.speechJoin);
//				CheckDlgButton(hWnd, IDC_SPEECH_PART, cfg.speechPart);
//				CheckDlgButton(hWnd, IDC_SPEECH_SIGNOFF, cfg.speechSignoff);
//				CheckDlgButton(hWnd, IDC_SPEECH_TOPIC, cfg.speechTopic);
//				CheckDlgButton(hWnd, IDC_SPEECH_INVITE, cfg.speechInvite);
//				CheckDlgButton(hWnd, IDC_SPEECH_NICKNAME, cfg.speechNick);
//				CheckDlgButton(hWnd, IDC_SPEECH_ACTIVE, cfg.speechActive);
//				return 1;
//			}
//			break;

//		case WM_NOTIFY:
//			switch(((NMHDR FAR *) lParam)->code)
//			{
//				case PSN_APPLY:
//					{
//						cfg.speechPublic = IsDlgButtonChecked(hWnd, IDC_SPEECH_PUBLIC);
//						cfg.speechAction = IsDlgButtonChecked(hWnd, IDC_SPEECH_ACTION);
//						cfg.speechPrivate = IsDlgButtonChecked(hWnd, IDC_SPEECH_PRIVATE);
//						cfg.speechCtcp = IsDlgButtonChecked(hWnd, IDC_SPEECH_CTCP);
//						cfg.speechNotifyOn = IsDlgButtonChecked(hWnd, IDC_SPEECH_NOTIFYSIGNON);
//						cfg.speechNotifyOff = IsDlgButtonChecked(hWnd, IDC_SPEECH_NOTIFYSIGNOFF);
//						cfg.speechJoin = IsDlgButtonChecked(hWnd, IDC_SPEECH_JOIN);
//						cfg.speechPart = IsDlgButtonChecked(hWnd, IDC_SPEECH_PART);
//						cfg.speechSignoff = IsDlgButtonChecked(hWnd, IDC_SPEECH_SIGNOFF);
//						cfg.speechTopic = IsDlgButtonChecked(hWnd, IDC_SPEECH_TOPIC);
//						cfg.speechInvite = IsDlgButtonChecked(hWnd, IDC_SPEECH_INVITE);
//						cfg.speechNick = IsDlgButtonChecked(hWnd, IDC_SPEECH_NICKNAME);
//						cfg.speechActive = IsDlgButtonChecked(hWnd, IDC_SPEECH_ACTIVE);
//						SaveConfig(ircconfig);
//					}
//					break;

//				case PSN_KILLACTIVE:
//					SetWindowLong(hWnd, DWL_MSGRESULT, FALSE);
//					return 1;
//					break;
//			}
//			break;
//	}
//	return 0;
//}

BOOL APIENTRY Cfg_Options(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	static PROPSHEETPAGE *ps;
	switch (uMsg)
	{
		case WM_INITDIALOG:
			{
				ps = (PROPSHEETPAGE *) lParam;
				CheckDlgButton(hWnd, IDC_OPTIONS_TIMESTAMP, cfg.timeStamp);
				CheckDlgButton(hWnd, IDC_OPTIONS_24HOUR, cfg.time24hour);
				CheckDlgButton(hWnd, IDC_OPTIONS_AUTOREJOIN, cfg.autoRejoin);
				CheckDlgButton(hWnd, IDC_OPTIONS_PAGE, cfg.pager);
				CheckDlgButton(hWnd, IDC_OPTIONS_AUTOAWAY, cfg.autoAway);
				SetDlgItemInt(hWnd, IDC_OPTIONS_AUTOAWAY_TIME, cfg.autoAwayTime, TRUE);
				return 1;
			}
			break;

		case WM_NOTIFY:
			switch(((NMHDR FAR *) lParam)->code)
			{
				case PSN_APPLY:
					{
						cfg.timeStamp = IsDlgButtonChecked(hWnd, IDC_OPTIONS_TIMESTAMP);
						cfg.time24hour = IsDlgButtonChecked(hWnd, IDC_OPTIONS_24HOUR);
						cfg.autoRejoin = IsDlgButtonChecked(hWnd, IDC_OPTIONS_AUTOREJOIN);
						cfg.pager = IsDlgButtonChecked(hWnd, IDC_OPTIONS_PAGE);
						cfg.autoAway = IsDlgButtonChecked(hWnd, IDC_OPTIONS_AUTOAWAY);
						cfg.autoAwayTime = GetDlgItemInt(hWnd, IDC_OPTIONS_AUTOAWAY_TIME, NULL, TRUE);
						SaveConfig(ircconfig);
					}
					break;

				case PSN_KILLACTIVE:
					SetWindowLong(hWnd, DWL_MSGRESULT, FALSE);
					return 1;
					break;
			}
			break;
	}
	return 0;
}

int CreatePropertySheet(HWND hWndOwner)
{
	PROPSHEETPAGE psp[4];
	PROPSHEETHEADER psh;

	psp[0].dwSize = sizeof(PROPSHEETPAGE);
	psp[0].dwFlags = PSP_USETITLE;
	psp[0].hInstance = g_hInst;
	psp[0].pszTemplate = MAKEINTRESOURCE(IDD_SERVER);
	psp[0].pszIcon = NULL;
	psp[0].pfnDlgProc = Cfg_Server;
	psp[0].pszTitle = "Server";
	psp[0].lParam = 0;

	psp[1].dwSize = sizeof(PROPSHEETPAGE);
	psp[1].dwFlags = PSP_USETITLE;
	psp[1].hInstance = g_hInst;
	psp[1].pszTemplate = MAKEINTRESOURCE(IDD_DCC);
	psp[1].pszIcon = NULL;
	psp[1].pfnDlgProc = Cfg_DCC;
	psp[1].pszTitle = "DCC";
	psp[1].lParam = 0;

	psp[2].dwSize = sizeof(PROPSHEETPAGE);
	psp[2].dwFlags = PSP_USETITLE;
	psp[2].hInstance = g_hInst;
	psp[2].pszTemplate = MAKEINTRESOURCE(IDD_OUTPUT);
	psp[2].pszIcon = NULL;
	psp[2].pfnDlgProc = Cfg_Display;
	psp[2].pszTitle = "Display";
	psp[2].lParam = 0;

//	psp[3].dwSize = sizeof(PROPSHEETPAGE);
//	psp[3].dwFlags = PSP_USETITLE;
//	psp[3].hInstance = g_hInst;
//	psp[3].pszTemplate = MAKEINTRESOURCE(IDD_SPEECH);
//	psp[3].pszIcon = NULL;
//	psp[3].pfnDlgProc = Cfg_Speech;
//	psp[3].pszTitle = "Speech";
//	psp[3].lParam = 0;

	psp[3].dwSize = sizeof(PROPSHEETPAGE);
	psp[3].dwFlags = PSP_USETITLE;
	psp[3].hInstance = g_hInst;
	psp[3].pszTemplate = MAKEINTRESOURCE(IDD_OPTIONS);
	psp[3].pszIcon = NULL;
	psp[3].pfnDlgProc = Cfg_Options;
	psp[3].pszTitle = "Options";
	psp[3].lParam = 0;

	ZeroMemory(&psh, sizeof(psh));
	psh.dwSize = sizeof(PROPSHEETHEADER);
	psh.dwFlags = PSH_PROPSHEETPAGE | PSH_NOAPPLYNOW;
	psh.hwndParent = hWndOwner;
	psh.hInstance = g_hInst;
	psh.pszIcon = NULL;
	psh.pszCaption = (LPSTR) "Preferences";
	psh.nPages = sizeof(psp) / sizeof(PROPSHEETPAGE);
	psh.nStartPage = 0;
	psh.ppsp = (LPCPROPSHEETPAGE) &psp;

	return (PropertySheet(&psh));
}

int CALLBACK BrowseCallbackProc(HWND hwnd,
        UINT uMsg, LPARAM lParam, LPARAM lpData)
{
    switch (uMsg) {
        case BFFM_INITIALIZED:
            /* change the selected folder. */
            SendMessage(hwnd, BFFM_SETSELECTION, TRUE, lpData);
            break;
        case BFFM_SELCHANGED:
            break;
        default:
            break;
    }
    return(0);
}

BOOL BrowseForFolder(HWND hwnd, /* parent window. */
        LPCSTR lpszRoot,        /* root folder. */
        LPCSTR lpszDefault,     /* default selection. */
        LPSTR lpszBuffer)       /* return buffer. */
{
    IMalloc* pMalloc;
    IShellFolder* pDesktop;
    LPITEMIDLIST pidlRoot, pidl;
    BROWSEINFO bi;
    BOOL bRet = FALSE;

    if (SHGetMalloc(&pMalloc) != NOERROR) return(FALSE);

    /* gets the ITEMIDLIST for the desktop folder. */
    if (SHGetDesktopFolder(&pDesktop) == NOERROR) {
          WCHAR wszPath[_MAX_PATH];
          ULONG cchEaten;
          ULONG dwAttr;

          /* converts the root path into unicode. */
          MultiByteToWideChar(CP_OEMCP, 0,
              lpszRoot, -1, wszPath, _MAX_PATH);

          /* translates the root path into ITEMIDLIST. */
          if (pDesktop->lpVtbl->ParseDisplayName(
                  pDesktop, NULL, NULL, wszPath,
                  &cchEaten, &pidlRoot, &dwAttr) != NOERROR)
              pidlRoot = NULL;

          pDesktop->lpVtbl->Release(pDesktop);
    }

    /* fills the structure. */
    bi.hwndOwner = hwnd;
    bi.pidlRoot = pidlRoot;
    bi.pszDisplayName = lpszBuffer;
    bi.lpszTitle = "Choose a folder.";
    bi.ulFlags = 0;
    bi.lpfn = (BFFCALLBACK)BrowseCallbackProc;
    bi.lParam = (LPARAM)lpszDefault;

    /* invokes the dialog. */
    if ((pidl = SHBrowseForFolder(&bi)) != NULL) {
        bRet = SHGetPathFromIDList(pidl, lpszBuffer);
        pMalloc->lpVtbl->Free(pMalloc, pidl);
    }

    /* clean up. */
    if (pidlRoot)
        pMalloc->lpVtbl->Free(pMalloc, pidlRoot);
    pMalloc->lpVtbl->Release(pMalloc);

    return(bRet);
}
