/* 0irc
 * Copyright (C) 2000-2001 Torsten Stelling <murphy@dev0.de>
 *
 * AuroreIRC
 * Copyright (C) 1999 Omar Kilani <omar@aurore.net>
 *
 * OpenIRC
 * Copyright (C) 1998 Damian Hodgkiss <mian@thrity4.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef _IRC_H_
#define _IRC_H_
#include <winsock.h>
#include <time.h>
#include "resource.h"

#define CM_TRAYICON 0xB000+84

#define DCC_CHAT 1
#define DCC_GET 2
#define DCC_TGET 3
#define DCC_SEND 4

#define MAX_NAMELEN 26
#define MAX_NICKLEN 12
#define MAX_USERLEN 8
#define MAX_DESCLEN 26
#define MAX_HOSTLEN 128
#define MAX_PATHLEN 256
#define MAX_SERVERLEN 256
#ifdef DLL
#define MAX_PIXMAP 256
#endif

// --- new notifyicondata
typedef struct _NOTIFYICONDATA50A {
        DWORD cbSize;
        HWND  hWnd;
        UINT  uID;
        UINT  uFlags;
        UINT  uCallbackMessage;
        HICON hIcon;
        CHAR  szTip[128];
		DWORD dwState;
		DWORD dwStateMask;
		CHAR  szInfo[256];
		UINT  uTimeout;
		CHAR  szInfoTitle[64];
		DWORD dwInfoFlags;
} NOTIFYICONDATA50A, *PNOTIFYICONDATA50A;

typedef NOTIFYICONDATA50A NOTIFYICONDATA50;
typedef PNOTIFYICONDATA50A PNOTIFYICONDATA50;

#define NIF_INFO		0x00000010

#define NIIF_NONE		0x00000000
#define NIIF_INFO		0x00000001
#define NIIF_WARNING	0x00000002
#define NIIF_ERROR		0x00000003
// --- end of new notifyicondata

typedef struct {
	char *identifier;
	char *data;
} styleType;

typedef struct l_dcc {
	struct l_dcc *prev;
	struct l_dcc *next;
	char file[MAX_PATHLEN];
	char nick[MAX_NICKLEN];
	HANDLE handle;
	SOCKET sock;
	struct sockaddr_in sin;
	long type;
	long len;
	long read;
	long wrote;
	time_t start;
} dccType;

typedef dccType *dccList;

typedef struct l_channel {
	char name[MAX_NAMELEN];
	struct l_channel *prev;
	struct l_channel *next;
} channelType;

typedef channelType *chanList;

typedef struct {
	HWND hEdit;
	HWND hInput;
	char name[MAX_NAMELEN];
	char nick[MAX_NICKLEN];
	char last_invite[MAX_NAMELEN];
	char nslookup[MAXGETHOSTSTRUCT];
	char currServer[MAX_SERVERLEN];
	int currPort;
	time_t setAway;
	int idle;
	SOCKET sock;
	long lag;
	BOOL loggedIn;
	chanList channels;
	channelType *cchan;
	dccList dcc;
	char buf[8192];
	int bufpos;

	char logfilename[MAX_PATHLEN];
} windowType;

typedef struct {
	char *name;
	void (*func)(char *args);
} commandType;

typedef struct {
	char nick[MAX_NICKLEN];
	char nick2[MAX_NICKLEN];
	char username[MAX_USERLEN];
	char desc[MAX_DESCLEN];
	char server[MAX_SERVERLEN];
	int dccBlockSize;
	int dccOverrideLocalhost;
	char dccOverrideHost[MAX_HOSTLEN];
	char dccReceivePath[MAX_PATHLEN];
	BOOL timeStamp;
	BOOL time24hour;
	BOOL autoRejoin;
	BOOL autoAway;
	BOOL pager;
	int autoAwayTime;
	RECT windowpos;
#ifdef DLL
	BOOL windowvisible;
	char tabPixmap[MAX_PIXMAP];
	char tabIcon[MAX_PIXMAP];
    COLORREF editColor;
	COLORREF textColor;
	COLORREF frameColor;
	BOOL executeLSCommands;
#endif
//	BOOL speechActive;
//	BOOL speechPublic;
//	BOOL speechAction;
//	BOOL speechPrivate;
//	BOOL speechCtcp;
//	BOOL speechNotifyOn;
//	BOOL speechNotifyOff;
//	BOOL speechJoin;
//	BOOL speechPart;
//	BOOL speechSignoff;
//	BOOL speechTopic;
//	BOOL speechInvite;
//	BOOL speechNick;
} configType;

extern configType cfg;
extern windowType *windows;
extern channelType *channels;
extern int currWindow, numWindows;
extern HWND hMainWnd, hTabWnd;;
extern HINSTANCE g_hInst; //, speechMod;
//extern BOOL speechOk;
extern char header[], version[];
extern char builddate[], copyright[], ircname[], mail[], homepage[];
extern char ircconfig[];
extern styleType styles[];
extern BOOL isTray;

extern int (FAR *InitializeSpeech)(void);
extern void (FAR *DestroySpeech)(void);
extern SOCKET ConnectToServer(char *host, int port);
extern int Send(SOCKET s, const char *format, ...);
extern void Put(int i, const char *format, ...);
extern void PutNoTime(int i, const char *format, ...);
extern void CreateNewWindow(char *title);
extern void CloseIrcWindow();
extern void DestroyChannels(int num);
extern void AddChannel(int num, char *name);
extern void DestroyChannel(int num, char *name);
extern channelType *FindChannel(int num, char *name);
extern int GetTokens(LPCSTR szString, LPSTR *lpszBuffers, DWORD dwNumBuffers, LPSTR szExtraParameters);
extern int CreatePropertySheet(HWND hWndOwner);
#ifndef DLL
extern void LoadConfig(char *ini);
extern void SaveConfig(char *ini);
extern void SaveConfigPos(char *ini);
#else
extern void LoadConfig();
#endif
extern dccType *FindDCC(int num, char *name);
extern void DestroyDCC(int num, char *name);
extern void AddDCC(int num, char *name);
extern void DestroyDCCs(int num);
extern void AddGetDCC(int num, char *nick, char *name, char *ip, char *port, char *size);
extern void AddTGetDCC(int num, char *nick, char *name, char *ip, char *port, char *size);
extern char *cvt_style(char *style, const char *format, ...);
extern void StopIdentd();

#ifdef DLL
	#ifdef __cplusplus
	extern "C" {
	#endif

__declspec( dllexport ) int initModuleEx(HWND parent, HINSTANCE dll, LPCSTR szPath);
__declspec( dllexport ) void quitModule(HINSTANCE dllInst);

	#ifdef __cplusplus
	}
	#endif
#endif

#endif