/* 0irc
 * Copyright (C) 2000-2001 Torsten Stelling <murphy@dev0.de>
 *
 * AuroreIRC
 * Copyright (C) 1999 Omar Kilani <omar@aurore.net>
 *
 * OpenIRC
 * Copyright (C) 1998 Damian Hodgkiss <mian@thrity4.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <windowsx.h>
#include <tchar.h>
#include <commctrl.h>
#include <richedit.h>
#include <winsock.h>
#include <stdarg.h>
#include <stdio.h>
#include <time.h>
#include <process.h>
#include "commands.h"
#include "irc.h"
#include "constants.h"
#ifdef DLL
#include "0ircdll/litestep/lsapi.h"
//#include "0ircdll/litestep/wharfdata.h"
#endif

#ifndef DLL
const LPCTSTR	szMainWindowClass = _T("zer0irc");
const LPCTSTR	szMainWindowTitle = _T("0irc");
const LPCTSTR	szMainWindowText = _T("0irc");
#else
const LPCTSTR	szMainWindowClass = _T("zer0ircDLL");
const LPCTSTR	szMainWindowTitle = _T("0ircDLL");
const LPCTSTR	szMainWindowText = _T("0ircDLL");
#endif

//int (FAR *InitializeSpeech)(void);
//void (FAR *DestroySpeech)(void);
//void (FAR *Say)(const char *, ...);

void ParseServer(int i, char *buf);
void ChangeTextFormat(HWND hWnd, char *face, int height, COLORREF col);
void AdjustWindowSize();
void StartIdentd();
void StopIdentd();

static void OnSize(HWND hWnd, UINT state, int x, int y);
static void OnPaint(HWND hWnd);
static void OnDestroy(HWND hWnd);
//static void OnCommand(HWND hWnd, int ID, HWND hWndCtl, UINT notify);

LRESULT CALLBACK MainWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK InputWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK EditWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

//HINSTANCE speechMod;
//BOOL speechOk = FALSE;
#ifndef DLL
BOOL isTray = FALSE;
#endif

WNDPROC oldInputProc, oldEditProc;
windowType *windows = NULL;
int numWindows = 0;
int currWindow  = -1;

char identBuf[8192];
int identPos;
SOCKET identSock;
BOOL connected = FALSE;
WSADATA wsa;
configType cfg;
HIMAGELIST hTabImages;
HFONT hMainFont, oldMainFont = NULL;
HWND hMainWnd, hTabWnd;
HINSTANCE g_hInst;
#ifdef DLL
// ls things
#define LM_POPUP             9182

HWND ParentWnd;

void BangCommands(HWND caller, char *name, char *args)
{
	// parse BangCommands here...
	if (!stricmp("!0IRCHIDE",name)) {
		ShowWindow(hMainWnd,SW_HIDE);
		return;
	}
	if (!stricmp("!0IRCSHOW",name)) {
		ShowWindow(hMainWnd,SW_SHOW);
		return;
	}
	if (!stricmp("!0IRCTOGGLE",name)) {
		if (IsWindowVisible(hMainWnd)) {
			ShowWindow(hMainWnd,SW_HIDE);
		} else {
			ShowWindow(hMainWnd,SW_SHOW);
		}
		return;
	}
	if (!stricmp("!0IRCFOCUS",name)) {
		ShowWindow(hMainWnd,SW_SHOW);
		SetForegroundWindow(hMainWnd);
		SetFocus(windows[currWindow].hInput);
		return;
	}
	if (!stricmp("!0IRCCOMMAND",name)) {
		if (args[0])
		{
			if (args[0] == '/')
			{
				 char token1[4096], args2[4096], *tokens[1], *cmd;
				 int count;

				 tokens[0] = token1;
				 ZeroMemory(&token1, sizeof(token1));
				 ZeroMemory(&args2, sizeof(args2));
				 count = GetTokens(args, tokens, 1, args2);
				 cmd = token1;
				 if (*cmd == '/') cmd++;
				 ParseLocalCommand(cmd, args2);
			} else {
				Sayit(args);
			}
		}
		return;
	}
}

int initModuleEx(HWND ParentWnd, HINSTANCE hInstance, LPCSTR szPath)
{
#else
int WINAPI WinMain
(
	HINSTANCE	hInstance,
	HINSTANCE	hPrevInstance,
	LPSTR		lpCmdLine,
	int 		nCmdShow
	)
{
	MSG msg;
#endif

	g_hInst = hInstance;

	if (WSAStartup(MAKEWORD(1, 1), &wsa))
	{
			MessageBox(NULL, "Error loading winsock", szMainWindowText, MB_OK);
			return 1;
	}

	if (!LoadLibrary("RICHED32.DLL"))
	{
			MessageBox(NULL, "Error loading rich edit", szMainWindowText, MB_OK);
			return 1;
	}

#ifdef DLL
	LoadConfig();
#else
	LoadConfig(ircconfig);
#endif

//	if (cfg.speechActive)
//	{
//		speechOk = TRUE;
//		if (!(speechMod = LoadLibrary("SPEECH.DLL")))
//		{
//			speechOk = FALSE;
//		}
//	}
//	if (speechOk)
//	{
//		InitializeSpeech = (int (FAR *)(void))GetProcAddress(speechMod, "InitializeSpeech");
//		DestroySpeech = (void (FAR *)(void))GetProcAddress(speechMod, "DestroySpeech");
//		Say = (void (FAR *)(const char *, ...))GetProcAddress(speechMod, "Say");
//		if (!InitializeSpeech || !DestroySpeech || !Say)
//		{
//			FreeLibrary(speechMod);
//			MessageBox(NULL, "Error in SPEECH.DLL, text-to-speech functions will not be available", szMainWindowText, MB_OK);
//			speechOk = FALSE;	
//		}
//	}

	InitCommonControls();
//	if (speechOk) InitializeSpeech();

	{
		WNDCLASS wc;

		ZeroMemory(&wc, sizeof(wc));
		wc.lpfnWndProc = MainWndProc;
		wc.hCursor = LoadCursor(NULL, IDC_ARROW);
		wc.hIcon = LoadIcon(hInstance, (const char *)IDI_AUROREIRC);
		wc.hInstance = hInstance;
//		wc.lpszMenuName = MAKEINTRESOURCE(IDR_MAINMENU);
		wc.lpszClassName = szMainWindowClass;
#ifndef DLL
		wc.hbrBackground = (HBRUSH)CreateSolidBrush(GetSysColor(COLOR_3DFACE));
#else
		wc.hbrBackground = (HBRUSH)CreateSolidBrush(cfg.frameColor);
#endif

		if (!RegisterClass(&wc))
		{
			MessageBox(NULL, "Error registering class", szMainWindowText, MB_OK);
			return 1;
		}
	}

	hMainFont = CreateFont(
		14,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		DEFAULT_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY,
		DEFAULT_PITCH,
		"Arial"
	);
#ifdef DLL
	ParentWnd=GetLitestepWnd();
	hMainWnd = CreateWindowEx(
		WS_EX_TOOLWINDOW,
		szMainWindowClass,
		szMainWindowTitle,
		WS_POPUP | WS_CLIPSIBLINGS | WS_CLIPCHILDREN,
		cfg.windowpos.left,
		cfg.windowpos.top,
		cfg.windowpos.right-cfg.windowpos.left,
		cfg.windowpos.bottom-cfg.windowpos.top,
		ParentWnd,
		NULL,
		g_hInst,
		NULL
	);
	SetWindowLong(hMainWnd,GWL_USERDATA,0x49474541);
	ParentWnd=FindWindow("DesktopBackgroundClass",NULL);
	if (ParentWnd!=0) SetParent(hMainWnd,ParentWnd);
#else
	hMainWnd = CreateWindow(
		szMainWindowClass,
		szMainWindowTitle,
		WS_THICKFRAME | WS_CAPTION | WS_SYSMENU | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_BORDER | WS_DLGFRAME | WS_OVERLAPPEDWINDOW | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
		cfg.windowpos.left,
		cfg.windowpos.top,
		cfg.windowpos.right-cfg.windowpos.left,
		cfg.windowpos.bottom-cfg.windowpos.top,
		NULL,
		NULL,
		g_hInst,
		NULL
	);
#endif
	if (!hMainWnd)
	{
		MessageBox(NULL, "Error creating main window", szMainWindowText, MB_OK);
		return 1;
	}

	hTabWnd = CreateWindow(
		WC_TABCONTROL,
		"",
		WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE | TCS_BUTTONS | TCS_HOTTRACK,
		0, 0,
		0, 0,
		hMainWnd,
		NULL,
		g_hInst,
		NULL
	);

	if (!hTabWnd)
	{
		MessageBox(NULL, "Error creating tab window", szMainWindowText, MB_OK);
		return 1;
	}

	SendMessage(hTabWnd, WM_SETFONT, (WPARAM)hMainFont, MAKELPARAM(TRUE, 0));
#ifndef DLL
	hTabImages = ImageList_Create(16, 16, ILC_COLOR32, 0, 0);
	ImageList_AddMasked(hTabImages, LoadImage(g_hInst, MAKEINTRESOURCE(IDB_ICONCHAN), IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR), RGB(255,0,255));
#else
	hTabImages = ImageList_Create(16, 16, ILC_COLOR32|ILC_MASK, 0, 0);
	if (strcmp(cfg.tabPixmap,"")) {
		ImageList_AddMasked(hTabImages, LoadLSImage(cfg.tabPixmap, NULL) , RGB(255,0,255));
	} else {
		if (strcmp(cfg.tabIcon,"")) {
			ImageList_AddIcon(hTabImages, LoadLSIcon(cfg.tabIcon, NULL));
		} else {
			ImageList_AddMasked(hTabImages, LoadImage(g_hInst, MAKEINTRESOURCE(IDB_ICONCHAN), IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR), RGB(255,0,255));
		}
	}
	SetClassLong(hTabWnd,GCL_HBRBACKGROUND,(HBRUSH)CreateSolidBrush(cfg.frameColor));
#endif
	TabCtrl_SetImageList(hTabWnd, hTabImages);
	CreateNewWindow("main");
	TabCtrl_SetCurFocus(hTabWnd, 0);

	SendMessage(hMainWnd, WM_NOTIFY, 0, 0);

#ifdef DLL
	if (cfg.windowvisible) {
#endif
		ShowWindow(hMainWnd, SW_SHOW);
#ifdef DLL
	} else {
		ShowWindow(hMainWnd, SW_HIDE);
	}
#endif
	ShowWindow(hTabWnd, SW_SHOW);
	AdjustWindowSize();

	SetCursor(LoadCursor(NULL, IDC_ARROW));

//	if (!speechOk)
//		Put(currWindow, "%s\n", "Unable to load SPEECH.DLL, text-to-speech functions will not be available");
	About(NULL);

	SetTimer(hMainWnd, 1, 15000, NULL);
	SetTimer(hMainWnd, 2, 1000, NULL);
	StopIdentd();
	StartIdentd();
#ifdef DLL
	AddBangCommandEx("!0IRCHIDE",BangCommands);
	AddBangCommandEx("!0IRCSHOW",BangCommands);
	AddBangCommandEx("!0IRCTOGGLE",BangCommands);
	AddBangCommandEx("!0IRCFOCUS",BangCommands);
	AddBangCommandEx("!0IRCCOMMAND",BangCommands);

	{
		int msgs[] = {LM_GETREVID, 0};

		SendMessage(GetLitestepWnd(), LM_REGISTERMESSAGE, (WPARAM)hMainWnd, (LPARAM)msgs);
	}
	return 0;
}

void quitModule(HINSTANCE dllInst)
{
	RemoveBangCommand("!0IRCHIDE");
	RemoveBangCommand("!0IRCSHOW");
	RemoveBangCommand("!0IRCTOGGLE");
	RemoveBangCommand("!0IRCFOCUS");
	RemoveBangCommand("!0IRCCOMMAND");
	{
		int msgs[] = {LM_GETREVID, 0};

		SendMessage(GetLitestepWnd(), LM_UNREGISTERMESSAGE, (WPARAM)hMainWnd, (LPARAM)msgs);
	}
#else
	while (GetMessage(&msg, 0, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
#endif
//	if (windows[currWindow].sock != NULL)
//		Send(windows[currWindow].sock,"Dumb ass pushed alt+f4");

	StopIdentd();

	if (windows)
	{
		int i;

		for (i = 0; i < numWindows; i++)
		{
			DestroyDCCs(i);
			DestroyChannels(i);
			DestroyWindow(windows[i].hInput);
			DestroyWindow(windows[i].hEdit);
			closesocket(windows[i].sock);
		}
		free(windows);
	}

	TabCtrl_DeleteAllItems(hTabWnd);
	DestroyWindow(hTabWnd);
	ImageList_Remove(hTabImages, -1);
	ImageList_Destroy(hTabImages);
	DeleteObject(hMainFont);
	WSACleanup();

//	if (speechOk)
//	{
//		DestroySpeech();
//		FreeLibrary(speechMod);
//	}

	// here was exception... i don't know if it is now leaking memory..?
	// quickfix 2001/10/4
//	{
//		int i;
//		for (i = 0; styles[i].identifier!=NULL; i++) free(styles[i].data);
//	}

#ifdef DLL
	return;
#else
	return 0;
#endif
}

LRESULT CALLBACK MainWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		HANDLE_MSG(hWnd, WM_DESTROY, OnDestroy);
		HANDLE_MSG(hWnd, WM_PAINT, OnPaint);
		HANDLE_MSG(hWnd, WM_SIZE, OnSize);
//		HANDLE_MSG(hWnd, WM_COMMAND, OnCommand);
#ifdef DLL
		case LM_GETREVID:
			{
				LPTSTR buf=(LPTSTR)(lParam);

				switch (wParam)
				{
					case 0:
						_stprintf(buf,"0irc.dll: v%s (%s)", version, builddate);
						break;
					case 1:
						_tcscpy(buf, &version[1]);
						break;
					default:
						_tcscpy(buf, "");
						break;
				}

				return _tcslen(buf);
			}
		case WM_WINDOWPOSCHANGING:
			{
			    WINDOWPOS *lpwp = (WINDOWPOS*)lParam;

			    lpwp->flags |= SWP_NOZORDER;
			}
			return 0;
		case WM_RBUTTONUP:
			{
				SendMessage(GetLitestepWnd(), LM_POPUP, (int)HIWORD(lParam), (int)LOWORD(lParam));
			}
			return 0;
#else
		case CM_TRAYICON:
			{
				if ((lParam==WM_LBUTTONUP)&&(isTray)) {
					NOTIFYICONDATA icondata;

					icondata.cbSize =sizeof(NOTIFYICONDATA);
					icondata.hWnd   =hMainWnd;
					icondata.uID    =1;
					icondata.uFlags =NIF_MESSAGE | NIF_ICON | NIF_TIP;
					icondata.uCallbackMessage = CM_TRAYICON;

					Shell_NotifyIcon(NIM_DELETE, &icondata);
					ShowWindow(hMainWnd,SW_SHOW);
					isTray=FALSE;
				}
			}
			return 0;
#endif
		case WM_TIMER:
			switch(wParam)
			{
			case 1:
				if (currWindow != -1)
				{
// 					if (windows[currWindow].sock != INVALID_SOCKET)
// 						Send(windows[currWindow].sock, "PRIVMSG %s :\001LAGSTAT %lu\001\r\n", windows[currWindow].nick, timeGetTime());
				}
				break;
			case 2:
				{
					int i;
					for (i = 0; i < numWindows; i++)  windows[i].idle++;
					if (cfg.autoAway && !windows[currWindow].setAway && windows[currWindow].loggedIn)
					{
						if (windows[currWindow].idle >= (cfg.autoAwayTime*60)) Away("autoaway");
					}
				}
				break;
			}
			break;

		case WM_SETFOCUS:
			{
				if (hWnd == hMainWnd && currWindow != -1)
					SetFocus(windows[currWindow].hInput);
			}
			break;

		case WM_SYSCOMMAND:
			{
#ifdef DLL
				wParam=0;
#else
				if ((wParam==SC_CLOSE)&&
				    (windows[currWindow].sock != NULL))
						Send(windows[currWindow].sock, "QUIT : Alt-F4\r\n");
#endif
//				    (windows))
//				{
//					int i;
//					for (i = 0; i < numWindows; i++)
//						Send(windows[i].sock, "QUIT : dumb ass hit alt-f4!\r\n");
//				}
			}
			break;

		case WM_CLOSE:
			{
				GetWindowRect(hWnd,&cfg.windowpos);
#ifndef DLL
				SaveConfigPos(ircconfig);
#endif
//				if (windows[currWindow].sock != NULL)
//					Quit("Dumb ass pushed alt+f4");
			}
			break;

		case WM_NOTIFY:
			{
				int num = TabCtrl_GetCurSel(hTabWnd);
				if (num != currWindow)
				{
					int i;

					for (i = 0; i < numWindows; i++)
					{
						ShowWindow(windows[i].hInput, SW_HIDE);
						ShowWindow(windows[i].hEdit, SW_HIDE);
					}
					ShowWindow(windows[num].hInput, SW_SHOW);
					ShowWindow(windows[num].hEdit, SW_SHOW);
					SetFocus(windows[num].hInput);
					SendMessage(windows[num].hEdit, EM_SCROLLCARET, 0, 0);
					currWindow = num;
					SendMessage(hMainWnd, WM_TIMER, 1, 0);
					UpdateWindow(hMainWnd);
					UpdateWindow(hTabWnd);
					UpdateWindow(windows[num].hInput);
					UpdateWindow(windows[num].hEdit);
				}
			}
			break;

		case WM_USER+0x1998:
			{
				int event = WSAGETSELECTEVENT(lParam);
				int err = WSAGETSELECTERROR(lParam);
				int i, num = -1;
				SOCKET s = (SOCKET)wParam;

				for (i = 0; i < numWindows; i++)
				{
					if (windows[i].sock == s) 
					{
						num = i;
						break;
					}
				}
				if (num > -1)
				{
					switch(event)
					{
						case FD_CONNECT:
							{
								struct sockaddr_in sin;
								int sinLen;

								sinLen = sizeof(sin);
								if (!getpeername(s, (struct sockaddr *)&sin, &sinLen)) Put(num, "%s\00314[\0030c\00315onnect\00314/\00315%s\00314(\00315%d\00314)]\00315\n", header, inet_ntoa(sin.sin_addr), ntohs(sin.sin_port));
								sprintf(windows[num].currServer, "%s", inet_ntoa(sin.sin_addr));
								windows[num].currPort = ntohs(sin.sin_port);
								Send(s, "USER %s # # :%s\r\nNICK %s\r\n", cfg.username, cfg.desc, windows[currWindow].nick);
							}
							break;

						case FD_CLOSE:
							{
								windows[num].sock = INVALID_SOCKET;
								ZeroMemory(&windows[num].buf, sizeof(windows[num].buf));
								ZeroMemory(&windows[numWindows].last_invite, sizeof(windows[numWindows].last_invite));
								windows[num].bufpos = 0;
								windows[num].lag = 0;
								windows[num].cchan = NULL;
								windows[num].loggedIn = FALSE;
								windows[num].idle = 0;
								windows[num].setAway = 0;
								DestroyChannels(num);
								Put(num, "%s error/disconnected\n", header);
							}
							break;

						case FD_READ:
							{
								char buf[8192];
								int ret, cbLen, x;

								ZeroMemory(&buf, sizeof(buf));
								cbLen = 0;
								/*while (cbLen < sizeof(buf))
								{
									ret = recv(s, (LPSTR)buf, sizeof(buf)-cbLen, 0);
									if (ret == SOCKET_ERROR)
									{
										break;
									}
									cbLen += ret;
								}*/
								ret = recv(s, (LPSTR)buf, sizeof(buf)-cbLen, 0);
								if (ret == SOCKET_ERROR)
								{
									break;
								}
								for (x  = 0; x < lstrlen(buf); x++)
								{
									windows[num].buf[windows[num].bufpos] = buf[x];
									windows[num].bufpos++;
									if (buf[x] == '\r')
										windows[num].buf[windows[num].bufpos-1] = 0;
									if (buf[x] == '\n')
									{
										windows[num].buf[windows[num].bufpos-1] = 0;
										ParseServer(num, windows[num].buf);
										ZeroMemory(&windows[num].buf, sizeof(windows[num].buf));
										windows[num].bufpos = 0;
									}
								}
							}
							break;
					}
				}
			}
			break;

		case WM_USER+0x1999:
			{
				int event = WSAGETSELECTEVENT(lParam);
				int err = WSAGETSELECTERROR(lParam);
				int i, num = currWindow;
				SOCKET s = (SOCKET)wParam;
				dccType *dcc;

				for (i = 0; i < numWindows; i++)
				{
					dccType *d;
					for (d = windows[i].dcc; d; d = d->next)
					{
						if (d->sock == s) 
						{
							dcc = d;
							num = i;
						}
					}
				}
				if (dcc)
				{
					switch(event)
					{
						case FD_ACCEPT:
							{
								if (dcc->type & DCC_SEND)
								{
									struct sockaddr_in sin;
									int sinLen;

									sinLen = sizeof(sin);
									accept(s, (struct sockaddr *)&sin, &sinLen);
									dcc->start = time(0);
								}
							}
							break;

						case FD_WRITE:
							if (dcc->type & DCC_SEND)
							{
								int sent, read, sinLen;
								char buf[8192];
								struct sockaddr_in sin;

								sinLen = sizeof(sin);
								if (!getpeername(s, (struct sockaddr *)&sin, &sinLen)) Put(num, "%s\00314[\0030d\00315cc\00314/\00315send\00314]\00315 to %s established \00314[\00315%s\00314(\00315%d\00314)]\00315\n", header, dcc->nick, inet_ntoa(sin.sin_addr), ntohs(sin.sin_port));
								ZeroMemory(&buf, sizeof(buf));
								ReadFile(dcc->handle, &buf, cfg.dccBlockSize, &read, NULL);
								sent = send(s, buf, read, 0);
							}
							break;

						case FD_READ:
							if (dcc->type & DCC_GET)
							{
								char buf[8192];
								int cbLen, ret, wrote;
								long bytes;

								ZeroMemory(&buf, sizeof(buf));
								cbLen = 0;
								ioctlsocket(s, FIONREAD, &cbLen);
								if (cbLen)
								{
									ret = recv(s, (LPSTR)buf, cbLen, 0);
									if (ret == SOCKET_ERROR)
									{
										break;
									}
									WriteFile(dcc->handle, buf, ret, &wrote, NULL);
									dcc->read += ret;
									bytes = htonl(dcc->read);
									send(s, (char *)&bytes, sizeof(bytes), 0);
									if (dcc->read == dcc->len)
									{
										double xfer, xtime, xspeed;

										xfer = dcc->read;
										xtime = time(0)-dcc->start;
										if (xfer == 0.0) xfer = 1.0;
										if (xtime == 0.0) xtime = 1.0;
										xspeed = (xfer / xtime) / 1024;
										CloseHandle(dcc->handle);
										closesocket(dcc->sock);
										Put(num, "%s\00314[\0030d\00315cc\00314/\00315get\00314]\00315 from %s \00314[\00315%s\00314(\00315%lu bytes\00314)]\00315 completed \00314@ \00315%2.4gkb/sec\00315\n", header, dcc->nick, dcc->file, dcc->len, xspeed);
									}
								}
							}
							if (dcc->type & DCC_TGET)
							{
								struct sockaddr_in sin;
								char buf[8192];
								int cbLen, ret, wrote, sinLen;
								long bytes;

								sinLen = sizeof(sin);
								ZeroMemory(&buf, sizeof(buf));
								cbLen = 0;
								ioctlsocket(s, FIONREAD, &cbLen);
								if (cbLen)
								{
									ret = recvfrom(s, (LPSTR)buf, cbLen, 0, (struct sockaddr *)&sin, &sinLen);
									if (ret == SOCKET_ERROR)
									{
										break;
									}
									WriteFile(dcc->handle, buf, ret, &wrote, NULL);
									dcc->read += ret;
									bytes = htonl(dcc->read);
									sendto(s, (char *)&bytes, sizeof(bytes), 0, (struct sockaddr *)&sin, sinLen);
									if (dcc->read == dcc->len)
									{
										double xfer, xtime, xspeed;

										xfer = dcc->read;
										xtime = time(0)-dcc->start;
										if (xfer == 0.0) xfer = 1.0;
										if (xtime == 0.0) xtime = 1.0;
										xspeed = (xfer / xtime) / 1024;
										CloseHandle(dcc->handle);
										closesocket(dcc->sock);
										Put(num, "%s\00314[\0030d\00315cc\00314/\00315tget\00314]\00315 from %s \00314[\00315%s\00314(\00315%lu bytes\00314)]\00315 completed \00314@ \00315%2.4gkb/sec\00315\n", header, dcc->nick, dcc->file, dcc->len, xspeed);
									}
								}
							}
							if (dcc->type & DCC_SEND)
							{
								char buf[8192];
								int cbLen, ret, read, sent;
								long bytes;

								ZeroMemory(&buf, sizeof(buf));
								cbLen = 0;
								ioctlsocket(s, FIONREAD, &cbLen);
								if (cbLen)
								{
									ret = recv(s, (LPSTR)buf, cbLen, 0);
									if (ret == SOCKET_ERROR)
									{
										break;
									}
									memcpy(&bytes, buf, sizeof(bytes));
									ZeroMemory(&buf, sizeof(buf));
									ret = ReadFile(dcc->handle, buf, cfg.dccBlockSize, &read, NULL);
									if (ret && read == 0)
									{
										double xfer, xtime, xspeed;

										xfer = dcc->wrote;
										xtime = time(0)-dcc->start;
										if (xfer == 0.0) xfer = 1.0;
										if (xtime == 0.0) xtime = 1.0;
										xspeed = (xfer / xtime) / 1024;
										CloseHandle(dcc->handle);
										closesocket(dcc->sock);
										Put(num, "%s\00314[\0030d\00315cc\00314/\00315send\00314]\00315 to %s \00314[\00315%s\00314(\00315%lu bytes\00314)]\00315 completed \00314@ \00315%2.4gkb/sec\00315\n", header, dcc->nick, dcc->file, dcc->len, xspeed);
										break;
									}
									sent = send(s, buf, read, 0);
									if (sent == SOCKET_ERROR)
									{
										break;
									}
									dcc->wrote += sent;
								}
							}
							break;
					}
				}
			}
			break;
	
		case WM_USER+0x2000:
			{
				int event = WSAGETSELECTEVENT(lParam);
				int err = WSAGETSELECTERROR(lParam);
				SOCKET s = (SOCKET)wParam;

				switch(event)
				{
					case FD_ACCEPT:
						{
							struct sockaddr_in sin;
							int sinLen;

							sinLen = sizeof(sin);
							accept(s, (struct sockaddr *)&sin, &sinLen);
						}
						break;

					case FD_READ:
						{
							char buf[8192];
							int ret, cbLen, x;
							long port1, port2;

							ZeroMemory(&buf, sizeof(buf));
							cbLen = 0;
							/*while (cbLen < sizeof(buf))
							{
								ret = recv(s, (LPSTR)buf, sizeof(buf)-cbLen, 0);
								if (ret == SOCKET_ERROR)
								{
									break;
								}
								cbLen += ret;
							}*/
							ret = recv(s, (LPSTR)buf, sizeof(buf), 0);
							if (ret == SOCKET_ERROR)
							{
								break;
							}
							for (x  = 0; x < lstrlen(buf); x++)
							{
								identBuf[identPos] = buf[x];
								identPos++;
								if (buf[x] == '\r')
									identBuf[identPos-1] = 0;
								if (buf[x] == '\n')
								{
									struct sockaddr_in sin;
									int sinLen;

									sinLen = sizeof(sin);
									if (!getpeername(s, (struct sockaddr *)&sin, &sinLen)) Put(currWindow, "%s\00314[\0030i\00315dent\00314/\00315%s\00314(\00315%d\00314)]\00315\n", header, inet_ntoa(sin.sin_addr), ntohs(sin.sin_port));
									identBuf[identPos-1] = 0;
									sscanf(identBuf, "%lu , %lu", &port1, &port2);
									if (port1 && port2) Send(s, "%lu , %lu : USERID : UNIX : %s\r\n", port1, port2, cfg.username);
									ZeroMemory(&identBuf, sizeof(identBuf));
									identPos = 0;
								}
							}
						}
						break;
				}
			}
			break;
		case WM_USER+0x2001:
			{
				int len = WSAGETASYNCBUFLEN(lParam);
				int err = WSAGETASYNCERROR(lParam);
				SOCKET s = (SOCKET)wParam;

				if (err)
				{
					switch(err)
					{
						case WSAHOST_NOT_FOUND: Put(currWindow, "%s\00314[\0030e\00315rror\00314/\00315nslookup\00314]\00315 host not found\n", header); break;
						case WSANO_RECOVERY: Put(currWindow, "%s\00314[\0030e\00315rror\00314/\00315nslookup\00314]\00315 non-recoverable error\n", header); break;
						case WSANO_DATA: Put(currWindow, "%s\00314[\0030e\00315rror\00314/\00315nslookup\00314]\00315 no data available\n", header); break;
					}
				} else {
					HOSTENT hp;
					struct sockaddr_in sin;

					memcpy(&hp, windows[currWindow].nslookup, len);
					memcpy(&sin.sin_addr, hp.h_addr_list[0], sizeof(DWORD));
					Put(currWindow, "%s\00314[\0030n\00315slookup\00314]\00315 resolved %s to %s \00314(\0030ctrl-g\00315 to copy\00314)\00315\n", header, hp.h_name, inet_ntoa(sin.sin_addr));
				}
			}
			break;
		case WM_USER+0x2002:
			// finger client
			{
				int event = WSAGETSELECTEVENT(lParam);
				int err = WSAGETSELECTERROR(lParam);
				int num = -1;
				SOCKET s = (SOCKET)wParam;

				switch (event)
				{
					case FD_CLOSE:
						break;

					case FD_READ:
						{
							char buf[8192];
							int ret, cbLen;
							
							ZeroMemory(&buf, sizeof(buf));
							cbLen = 0;
							/*while (cbLen < sizeof(buf))
							{
								ret = recv(s, (LPSTR)buf, sizeof(buf)-cbLen, 0);
								if (ret == SOCKET_ERROR)
								{
									break;
								}
								cbLen += ret;
							}*/
							ret = recv(s, (LPSTR)buf, sizeof(buf), 0);
							if (ret == SOCKET_ERROR)
								break;

//							hEdit = GetDlgItem(hwnd, IDC_FINGER_DISPLAY);
//							SendMessage(hEdit, EM_SETSEL, 0x7FFFFFFF, 0x7FFFFFFF);
//							SendMessage(hEdit, EM_REPLACESEL, 0, (long)buf);
//							Put(currWindow,"%s\00314[\0030f\00315inger\00314/\00315---start---\00314]\00315\n",header);
							Put(currWindow, buf);
//							Put(currWindow,"%s\00314[\0030f\00315inger\00314/\00315---end---\00314]\00315\n",header);
						}
						break;
				}
			}
			break;
		}
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

LRESULT CALLBACK EditWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
#ifdef DLL
	switch(uMsg)
	{
		case WM_RBUTTONUP:
			{
				SendMessage(GetLitestepWnd(), LM_POPUP, (int)HIWORD(lParam), (int)LOWORD(lParam));
			}
			return 0;
/*		case WM_SETFOCUS:
//		case WM_LBUTTONUP:
			{
				int i;

				for (i = 0; i < numWindows; i++)
				{
					if (hWnd == windows[i].hEdit)
					{
						Message(hWnd,WM_COPY,0,0);
						SetFocus(windows[i].hInput);
						return 1;
					}
				}
			}
			return 1;*/
	}
#endif
	return CallWindowProc(oldEditProc, hWnd, uMsg, wParam, lParam);
}

LRESULT CALLBACK InputWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	static long effects = 0;
#ifndef DLL
	static COLORREF color = RGB(192,192,192);
#else
	COLORREF color = cfg.textColor;
#endif

	switch(uMsg)
	{
#ifdef DLL
		case WM_RBUTTONUP:
			{
				SendMessage(GetLitestepWnd(), LM_POPUP, (int)HIWORD(lParam), (int)LOWORD(lParam));
			}
			return 0;
#endif
		case WM_CHAR: 
			{
				if (wParam == '\002')
				{
					CHARFORMAT fmt;
					SendMessage(hWnd, EM_GETCHARFORMAT, 0, (LPARAM)&fmt);
					fmt.cbSize = sizeof(CHARFORMAT);
					fmt.dwMask = CFM_BOLD | CFM_COLOR | CFM_UNDERLINE;
					if (effects & CFE_BOLD)
						effects &= ~CFE_BOLD;
					else
						effects |= CFE_BOLD;
					fmt.crTextColor = color;
					fmt.dwEffects = effects;
					SendMessage(hWnd, EM_SETSEL, 0x7FFFFFFF, 0x7FFFFFFF);
					SendMessage(hWnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&fmt);
					return 0;
				}
				if (wParam == '\025')
				{
					CHARFORMAT fmt;
					SendMessage(hWnd, EM_GETCHARFORMAT, 0, (LPARAM)&fmt);
					fmt.cbSize = sizeof(CHARFORMAT);
					fmt.dwMask = CFM_BOLD | CFM_COLOR | CFM_UNDERLINE;
					if (effects & CFE_UNDERLINE)
						effects &= ~CFE_UNDERLINE;
					else
						effects |= CFE_UNDERLINE;
					fmt.dwEffects = effects;
					fmt.crTextColor = color;
					SendMessage(hWnd, EM_SETSEL, 0x7FFFFFFF, 0x7FFFFFFF);
					SendMessage(hWnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&fmt);
					return 0;
				}
				if (wParam == VK_RETURN) 
				{
					CHARFORMAT fmt;
					char command[256];

					windows[currWindow].idle = 0;
#ifndef DLL
					color = RGB(210,210,210);
#else
					color = cfg.textColor;
#endif
					effects = 0;
					ZeroMemory(&command, sizeof(command));
					Edit_GetText(hWnd, (char *)command, sizeof(command));
					Edit_SetText(hWnd, "");
					SendMessage(hWnd, EM_GETCHARFORMAT, 0, (LPARAM)&fmt);
					fmt.cbSize = sizeof(CHARFORMAT);
					fmt.dwMask = CFM_BOLD | CFM_COLOR | CFM_UNDERLINE;
					fmt.dwEffects = effects;
					fmt.crTextColor = color;
					SendMessage(hWnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&fmt);
					if (command[0])
					{
#ifdef DLL
						if ((command[0] == '/')||((command[0] == '!')&&(cfg.executeLSCommands)))
#else
						if (command[0] == '/')
#endif
						{
							 char token1[4096], args[4096], *tokens[1], *cmd;
							 int count;

							 tokens[0] = token1;
							 ZeroMemory(&token1, sizeof(token1));
							 ZeroMemory(&args, sizeof(args));
							 count = GetTokens(command, tokens, 1, args);
							 cmd = token1;
							 if (*cmd == '/') cmd++;
							 ParseLocalCommand(cmd, args);
						} else {
							Sayit(command);
						}
					}
					return 1;
				} else {
					SHORT control = GetAsyncKeyState(VK_CONTROL);

					if (HIBYTE(control))
					{
						switch((char)(wParam + 64))
						{
							case 'G':
								{
									if (windows[currWindow].nslookup[0])
									{
										HOSTENT hp;
										char ip[16], *ptr;
										HGLOBAL gBuf;
										struct sockaddr_in sin;

										memcpy(&hp, windows[currWindow].nslookup, sizeof(hp));
										memcpy(&sin.sin_addr, hp.h_addr_list[0], sizeof(DWORD));
										strncpy(ip, inet_ntoa(sin.sin_addr), sizeof(ip));
										if (!(gBuf = GlobalAlloc(GMEM_DDESHARE, lstrlen(ip)+1))) return 1;
										if (!OpenClipboard(hMainWnd)) return 1;
										EmptyClipboard();
										ptr = GlobalLock(gBuf);
										memcpy(ptr, ip, lstrlen(ip));
										ptr[lstrlen(ip)] = 0;
										GlobalUnlock(gBuf);
										SetClipboardData(CF_TEXT, gBuf);
										CloseClipboard();
										Put(currWindow, "%s Copied %s to clipboard\n", header, ip);
									} else
										Put(currWindow, "%s No address to copy\n", header);
								}
								return 1;
							case 'I':
								if (windows[currWindow].last_invite[0]) Join(windows[currWindow].last_invite); else
								Put(currWindow, "%s You have not been invited to any channels\n", header);
								return 1;
							case 'X':
								if (windows[currWindow].cchan)
								{
									if (windows[currWindow].cchan->next)
										Join(windows[currWindow].cchan->next->name);
									else if (windows[currWindow].channels)
										Join(windows[currWindow].channels->name);
								}
								return 1;
						}
					}
				}
			}
			break;
	}
	return CallWindowProc(oldInputProc, hWnd, uMsg, wParam, lParam);
}

void CreateNewWindow(char *title)
{
	if (!windows)
		windows = (windowType *)malloc(sizeof(windowType));
	else
		windows = realloc(windows, (numWindows+1)*sizeof(windowType));

	strcpy(windows[numWindows].name, title);
	{
		TC_ITEM tie;

		ZeroMemory(&tie, sizeof(TC_ITEM));
		tie.mask = TCIF_TEXT | TCIF_STATE | TCIF_IMAGE;
		tie.iImage = 0;
		tie.pszText = title;
		TabCtrl_InsertItem(hTabWnd, numWindows, &tie);
	}

	{
		RECT r;

		GetClientRect(hTabWnd, &r);

		if (!(windows[numWindows].hInput = CreateWindowEx(
			WS_EX_LEFT | WS_EX_LTRREADING | WS_EX_RIGHTSCROLLBAR,
			"RichEdit",
			"",
#ifdef DLL
			WS_CHILD | WS_GROUP | WS_TABSTOP | ES_LEFT | ES_AUTOHSCROLL,
#else
			WS_BORDER | WS_CHILD | WS_GROUP | WS_TABSTOP | ES_LEFT | ES_AUTOHSCROLL,
#endif
			0, 0,
			0, 0,
			hTabWnd,
			NULL,
			g_hInst,
			NULL
		))) MessageBox(NULL, "Error creating input window", szMainWindowText, MB_OK);
		oldInputProc = (WNDPROC)GetWindowLong(windows[numWindows].hInput, GWL_WNDPROC);
		SetWindowLong(windows[numWindows].hInput, GWL_WNDPROC, (int)InputWndProc);

		if (!(windows[numWindows].hEdit = CreateWindowEx(
			WS_EX_LEFT | WS_EX_LTRREADING | WS_EX_RIGHTSCROLLBAR,
			"RichEdit",
			"",
#ifdef DLL
			WS_CHILD | WS_GROUP | WS_TABSTOP | ES_LEFT | ES_MULTILINE | WS_VSCROLL | ES_READONLY | ES_AUTOVSCROLL,
#else
			WS_BORDER | WS_CHILD | WS_GROUP | WS_TABSTOP | ES_LEFT | ES_MULTILINE | WS_VSCROLL | ES_READONLY | ES_AUTOVSCROLL,
#endif
			0, 0,
			0, 0,
			hTabWnd,
			NULL,
			g_hInst,
			NULL
		))) MessageBox(NULL, "Error creating view window", szMainWindowText, MB_OK);
		oldEditProc = (WNDPROC)GetWindowLong(windows[numWindows].hEdit, GWL_WNDPROC);
		SetWindowLong(windows[numWindows].hEdit, GWL_WNDPROC, (int)EditWndProc);
	}

	SendMessage(windows[numWindows].hEdit, EM_AUTOURLDETECT, TRUE, 0);
#ifndef DLL
	SendMessage(windows[numWindows].hEdit, EM_SETBKGNDCOLOR, FALSE, RGB(0,0,0));
	SendMessage(windows[numWindows].hInput, EM_SETBKGNDCOLOR, FALSE, RGB(0,0,0));
#else
	SendMessage(windows[numWindows].hEdit, EM_SETBKGNDCOLOR, FALSE, cfg.editColor);
	SendMessage(windows[numWindows].hInput, EM_SETBKGNDCOLOR, FALSE, cfg.editColor);
#endif
	ShowWindow(windows[numWindows].hInput, SW_HIDE);
	ShowWindow(windows[numWindows].hEdit, SW_HIDE);

#ifndef DLL
	ChangeTextFormat(windows[numWindows].hEdit, "Verdana", 11, RGB(192,192,192));
	ChangeTextFormat(windows[numWindows].hInput, "Verdana", 11, RGB(192,192,192));
#else
	ChangeTextFormat(windows[numWindows].hEdit, "Verdana", 11, cfg.textColor);
	ChangeTextFormat(windows[numWindows].hInput, "Verdana", 11, cfg.textColor);
#endif

	strcpy(windows[numWindows].nick, cfg.nick);
	windows[numWindows].sock = INVALID_SOCKET;
	windows[numWindows].loggedIn = FALSE;
	ZeroMemory(&windows[numWindows].buf, sizeof(windows[numWindows].buf));
	ZeroMemory(&windows[numWindows].last_invite, sizeof(windows[numWindows].last_invite));
	ZeroMemory(&windows[numWindows].nslookup, sizeof(windows[numWindows].nslookup));
	windows[numWindows].bufpos = 0;
	windows[numWindows].channels = NULL;
	windows[numWindows].cchan = NULL;
	windows[numWindows].lag = 0;
	windows[numWindows].dcc = NULL;
	windows[numWindows].idle = 0;
	windows[numWindows].setAway = 0;
	ZeroMemory(&windows[numWindows].logfilename, sizeof(windows[numWindows].logfilename));
	numWindows++;
	AdjustWindowSize();
	InvalidateRect(hMainWnd, NULL, TRUE);
}

void CloseIrcWindow()
{
	if (numWindows==1)
		return;
	
	DestroyDCCs(currWindow);
	DestroyChannels(currWindow);
	DestroyWindow(windows[currWindow].hInput);
	DestroyWindow(windows[currWindow].hEdit);
	closesocket(windows[currWindow].sock);
	TabCtrl_DeleteItem(hTabWnd, currWindow);
	memcpy(&windows[currWindow], &windows[currWindow+1], sizeof(windowType)*(numWindows-currWindow-1));
	windows = realloc(windows, (numWindows-1)*sizeof(windowType));
	numWindows--;
	currWindow=-1;
	TabCtrl_SetCurSel(hTabWnd, 0);
	TabCtrl_SetCurFocus(hTabWnd, 0);
	SendMessage(hMainWnd, WM_NOTIFY, 0, 0);
}

void AdjustWindowSize()
{
	RECT r;
	register int i;

	GetClientRect(hMainWnd, &r);
	SetWindowPos(hTabWnd, NULL, r.left, r.top, r.right, r.bottom-1, SWP_NOZORDER);
	GetClientRect(hTabWnd, &r);
	for (i = 0; i < numWindows; i++)
	{
#ifdef DLL
		SetWindowPos(windows[i].hEdit, NULL, r.left , r.top + 23, r.right , r.bottom - 40, SWP_NOZORDER);
		SetWindowPos(windows[i].hInput, NULL, r.left , r.bottom - 16, r.right , 16, SWP_NOZORDER);
#else
		SetWindowPos(windows[i].hEdit, NULL, r.left + 5, r.top + 25, r.right - 10, r.bottom - 50, SWP_NOZORDER);
		SetWindowPos(windows[i].hInput, NULL, r.left + 5, r.bottom - 28, r.right - 10, 24, SWP_NOZORDER);
#endif
	}
}

static void OnDestroy(HWND hWnd)
{
#ifndef DLL
	PostQuitMessage(0);
#endif
}

static void OnSize(HWND hWnd, UINT state, int x, int y)
{
	if (hWnd == hMainWnd)
	{
		InvalidateRect(hWnd, NULL, TRUE);
	}
	AdjustWindowSize();
}

//static void OnCommand(HWND hWnd, int ID, HWND hWndCtl, UINT notify)
//{
//	switch(ID)
//	{
//		case IDC_SERVER_EXIT: SendMessage(hWnd, WM_SYSCOMMAND, SC_CLOSE, 0); break;
//		case IDC_OPTIONS_PREFS: _beginthread(CreatePropertySheet, 0, hWnd); break;
//		case IDC_TOOLS_FINGER: 
//			{
//				if  (DialogBox(
//					g_hInst,
//					MAKEINTRESOURCE(IDD_FINGER),
//					hMainWnd,
//					FingerDlgProc
//				) == -1)
//					MessageBox(hMainWnd, "Unable to create finger dialog", szMainWindowText, MB_OK);
//			}
//			break;
//		case IDC_HELP_ABOUT: _beginthread(CreateAboutWindow, 0, hWnd); break;
//		case IDC_SERVER_CONNECT:
//			{
//				StartIdentd();
//				Server(cfg.server);
//			}
//			break;
//		case IDC_SERVER_DISCONNECT:
//			{
//				closesocket(windows[currWindow].sock);
//				windows[currWindow].sock = INVALID_SOCKET;
//				ZeroMemory(&windows[currWindow].buf, sizeof(windows[currWindow].buf));
//				ZeroMemory(&windows[numWindows].last_invite, sizeof(windows[numWindows].last_invite));
//				windows[currWindow].bufpos = 0;
//				windows[currWindow].lag = 0;
//				windows[currWindow].cchan = NULL;
//				windows[currWindow].loggedIn = FALSE;
//				windows[currWindow].idle = 0;
//				windows[currWindow].setAway = 0;
//				DestroyChannels(currWindow);
//				Put(currWindow, "%s\00314[\0030d\00315isconnect\00314/\00315%s\00314(\00315%d\00314)]\00315\n", header, windows[currWindow].currServer, windows[currWindow].currPort);
//				StopIdentd();
//			}
//			break;
//	}
//}

static void OnPaint(HWND hWnd)
{
	PAINTSTRUCT ps;
	HDC hDC = BeginPaint(hWnd, &ps);
	RECT r;

	if (currWindow == -1) return;
	GetClientRect(hWnd, &r);

	EndPaint(hWnd, &ps);
}

void ChangeTextFormat(HWND hWnd, char *face, int height, COLORREF col)
{
	CHARFORMAT fmt;

	SendMessage(hWnd, EM_GETCHARFORMAT, 0, (LONG)&fmt);
	fmt.cbSize = sizeof(CHARFORMAT);
	fmt.dwEffects = 0;
	fmt.dwMask = CFM_COLOR | CFM_FACE | CFM_SIZE | CFM_BOLD;
	fmt.crTextColor = col;
	strcpy(fmt.szFaceName, face);
	fmt.yHeight = height*15;
	SendMessage(hWnd, EM_SETCHARFORMAT, SCF_ALL, (LONG)&fmt);
}

int GetTokens(LPCSTR szString, LPSTR *lpszBuffers, DWORD dwNumBuffers, LPSTR szExtraParameters)
{
	register int		index = 0;
	char	quoteChar = 0;

	char	buffer[4096];
	char	output[4096];
	char	*pOutput = NULL;
	DWORD	dwBufferCount = 0;

	strcpy (buffer, szString);

	pOutput = output;

	while (buffer[index] && dwBufferCount < dwNumBuffers)
	{
		BOOL skipWhitespace = FALSE;

		switch (buffer[index])
		{
		case '"':
		case '\'':
			{
				if (!quoteChar)
				{
					quoteChar = buffer[index];
					break;
				}
				else
				{
					if (quoteChar == buffer[index])
					{
						quoteChar = 0;
						strcpy (*lpszBuffers, output);
						lpszBuffers++;
						dwBufferCount++;

						if (dwBufferCount < dwNumBuffers)
						{
							(*lpszBuffers)[0] = '\0';
						}
						pOutput = output;
						*pOutput = '\0';
						skipWhitespace = TRUE;
						break;
					}
					else
					{
						*pOutput++ = buffer[index];
						*pOutput = '\0';
						break;
					}
				}
			}
		case ' ':
		case '\t':
			{
				if (!quoteChar)
				{
					if (strlen (output))
					{
						strcpy (*lpszBuffers, output);
						lpszBuffers++;
						dwBufferCount++;
						if (dwBufferCount < dwNumBuffers)
						{
							(*lpszBuffers)[0] = '\0';
						}
						pOutput = output;
						*pOutput = '\0';
						skipWhitespace = TRUE;
					}
				}
				else
				{
					*pOutput++ = buffer[index];
					*pOutput = '\0';
				}
				break;
			}
		default:
			{
				*pOutput++ = buffer[index];
				*pOutput = '\0';
				break;
			}
		}

		index++;

		if (skipWhitespace)
		{
			while (isspace (buffer[index]))
			{
				index++;
			}
		}
	}

	if (strlen (output))
	{
		if (dwBufferCount < dwNumBuffers)
		{
			dwBufferCount++;

			strcat (*lpszBuffers, output);
		}
	}

	if (szExtraParameters && dwBufferCount == dwNumBuffers)
	{
		strcpy (szExtraParameters, buffer + index);
	}

	return dwBufferCount;
}

// logfile processing...
void LogToFile(int i, const char *text)
{
	HANDLE hf;
	int num;

	if (windows[currWindow].logfilename[0]!='\0') {
//	if (stricmp(windows[i].logfilename,"")) {
		hf = CreateFile(windows[i].logfilename, GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_ALWAYS,
			FILE_ATTRIBUTE_NORMAL, NULL);
		SetFilePointer(hf,GetFileSize(hf,0),0,FILE_BEGIN);
		WriteFile(hf,text,lstrlen(text),&num,NULL);
		CloseHandle(hf);
	}
}

void PutAddon(int i,char *ptr,char buf[8192])
{
		CHARFORMAT fmt;
		SYSTEMTIME tm;
		register int x, y;
//		register int len;
		char sbuf[8192];
		long effects = 0;
#ifndef DLL
		COLORREF color = RGB(210,210,210);
#else
		COLORREF color = cfg.textColor;
#endif

		ZeroMemory(&sbuf, sizeof(sbuf));

		SendMessage(windows[i].hEdit, EM_SETSEL, 0x7FFFFFFF, 0x7FFFFFFF);
		SendMessage(windows[i].hEdit, EM_GETCHARFORMAT, 0, (LPARAM)&fmt);
		fmt.cbSize = sizeof(CHARFORMAT);
		fmt.dwMask = CFM_BOLD | CFM_COLOR | CFM_UNDERLINE;
		fmt.dwEffects = effects;
		fmt.crTextColor = color;
		SendMessage(windows[i].hEdit, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&fmt);
		y = 0;
		for (x = 0; x < lstrlen(buf); x++)
		{
			switch(buf[x])
			{
				case '\002':
					{
						if (sbuf[0])
						{
							SendMessage(windows[i].hEdit, EM_REPLACESEL, 0, (LPARAM)sbuf);
							SendMessage(windows[i].hEdit, EM_SCROLLCARET, 0, 0);
							SendMessage(windows[i].hEdit, EM_SETSEL, 0x7FFFFFFF, 0x7FFFFFFF);
							LogToFile(i,sbuf);
						}
						ZeroMemory(&sbuf, sizeof(sbuf));
						y = 0;
						SendMessage(windows[i].hEdit, EM_GETCHARFORMAT, 0, (LPARAM)&fmt);
						fmt.cbSize = sizeof(CHARFORMAT);
						fmt.dwMask = CFM_BOLD;
						if (effects & CFE_BOLD)
							effects &= ~CFE_BOLD;
						else
							effects |= CFE_BOLD;
						fmt.dwEffects = effects;
						SendMessage(windows[i].hEdit, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&fmt);
					}
					break;

				case '\003':
					{
						char scol[3];
						if (sbuf[0])
						{
							SendMessage(windows[i].hEdit, EM_REPLACESEL, 0, (LPARAM)sbuf);
							SendMessage(windows[i].hEdit, EM_SCROLLCARET, 0, 0);
							SendMessage(windows[i].hEdit, EM_SETSEL, 0x7FFFFFFF, 0x7FFFFFFF);
							LogToFile(i,sbuf);
						}
						ZeroMemory(&sbuf, sizeof(sbuf));
						y = 0;
						ZeroMemory(&scol, sizeof(scol));
						if (x < lstrlen(buf)-1)
						{
							if (isdigit(buf[x+1]))
							{
								scol[0] = buf[x+1];
								x++;
							}
							if (x < lstrlen(buf)-1)
							{
								if (isdigit(buf[x+1]))
								{
									scol[1] = buf[x+1];
									x++;
								}
							}
						}
						if (scol[0])
						{
							switch (atoi(scol))
							{
								case 0: color = RGB(255,255,255); break;
								case 1: color = RGB(0, 0, 0); break;
								case 2: color = RGB(0, 0, 127); break;
								case 3: color = RGB(0, 147, 0); break;
								case 4: color = RGB(255, 0, 0); break;
								case 5: color = RGB(127, 0, 0); break;
								case 6: color = RGB(156, 0, 156); break;
								case 7: color = RGB(252, 127, 0); break;
								case 8: color = RGB(255, 255, 0); break;
								case 9: color = RGB(0, 252, 0); break;
								case 10: color = RGB(0, 147, 147); break;
								case 11: color = RGB(0, 255, 255); break;
								case 12: color = RGB(0, 0, 252); break;
								case 13: color = RGB(255, 0, 255); break;
								case 14: color = RGB(127, 127, 127); break;
								case 15: color = RGB(210, 210, 210); break;
							}
							SendMessage(windows[i].hEdit, EM_GETCHARFORMAT, 0, (LPARAM)&fmt);
							fmt.cbSize = sizeof(CHARFORMAT);
							fmt.dwMask = CFM_COLOR | CFM_BOLD;
							fmt.dwEffects = effects;
							fmt.crTextColor = color;
							SendMessage(windows[i].hEdit, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&fmt);
						}
					}
					break;

				case '\017':
					{
						if (sbuf[0])
						{
							SendMessage(windows[i].hEdit, EM_REPLACESEL, 0, (LPARAM)sbuf);
							SendMessage(windows[i].hEdit, EM_SCROLLCARET, 0, 0);
							SendMessage(windows[i].hEdit, EM_SETSEL, 0x7FFFFFFF, 0x7FFFFFFF);
							LogToFile(i,sbuf);
						}
						ZeroMemory(&sbuf, sizeof(sbuf));
						y = 0;
						SendMessage(windows[i].hEdit, EM_GETCHARFORMAT, 0, (LPARAM)&fmt);
						fmt.cbSize = sizeof(CHARFORMAT);
						fmt.dwMask = CFM_BOLD;
						effects = 0;
						fmt.dwEffects = effects;
						SendMessage(windows[i].hEdit, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&fmt);
					}
					break;

				case '\037':
					{
						if (sbuf[0])
						{
							SendMessage(windows[i].hEdit, EM_REPLACESEL, 0, (LPARAM)sbuf);
							SendMessage(windows[i].hEdit, EM_SCROLLCARET, 0, 0);
							SendMessage(windows[i].hEdit, EM_SETSEL, 0x7FFFFFFF, 0x7FFFFFFF);
							LogToFile(i,sbuf);
						}
						ZeroMemory(&sbuf, sizeof(sbuf));
						y = 0;
						SendMessage(windows[i].hEdit, EM_GETCHARFORMAT, 0, (LPARAM)&fmt);
						fmt.cbSize = sizeof(CHARFORMAT);
						fmt.dwMask = CFM_UNDERLINE;
						if (effects & CFE_UNDERLINE)
							effects &= ~CFE_UNDERLINE;
						else
							effects |= CFE_UNDERLINE;
						fmt.dwEffects = effects;
						SendMessage(windows[i].hEdit, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&fmt);
					}
					break;

				case '\006':
				case '\022':
				case '\023':
				case '\026':
					break;

				default:
					{
						sbuf[y] = buf[x];
						y++;
					}
					break;
			}
		}
		if (sbuf[0])
		{
			SendMessage(windows[i].hEdit, EM_REPLACESEL, 0, (LPARAM)sbuf);
			SendMessage(windows[i].hEdit, EM_SCROLLCARET, 0, 0);
			SendMessage(windows[i].hEdit, EM_SETSEL, 0x7FFFFFFF, 0x7FFFFFFF);
			LogToFile(i,sbuf);
		}
}

void PutNoTime(int i, const char *format, ...)
{
	if (format && i != -1)
	{

		register int len;
		va_list args;
		char buf[8192];
		char *ptr;

		ZeroMemory(&buf, sizeof(buf));
		len = lstrlen(buf);
		ptr = buf + len;
		va_start(args, format);
		_vsnprintf(ptr, sizeof(buf) - len, format, args);
		va_end(args);

		PutAddon(i,ptr,buf);
	}
}

void Put(int i, const char *format, ...)
{
	if (format && i != -1)
	{
		CHARFORMAT fmt;
		SYSTEMTIME tm;
		register int len;
		va_list args;
		char buf[8192];
		char *ptr;

		ZeroMemory(&buf, sizeof(buf));
		if (cfg.timeStamp)
		{
			GetLocalTime(&tm);
			if (cfg.time24hour) {
				wsprintf(buf, "[%02d:%02d] ", tm.wHour, tm.wMinute);
			} else {
				if (tm.wHour > 11)
					wsprintf(buf, "[%02d:%02dpm] ", tm.wHour - 12, tm.wMinute);
				else
					wsprintf(buf, "[%02d:%02dam] ", tm.wHour?tm.wHour:12, tm.wMinute);
			}
		}
		len = lstrlen(buf);
		ptr = buf + len;
		va_start(args, format);
		_vsnprintf(ptr, sizeof(buf) - len, format, args);
		va_end(args);
		
		PutAddon(i,ptr,buf);
	}
}

SOCKET ConnectToServer(char *host, int port)
{
	struct hostent *hp;
	struct sockaddr_in sin;
	SOCKET s;

//	if (speechOk) Say("Connecting to %s", host);
	ZeroMemory(&sin, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = htons(port);
	sin.sin_addr.s_addr = inet_addr(host);
	if (sin.sin_addr.s_addr == INADDR_NONE)
	{
		hp = gethostbyname(host);
		if (hp == NULL)
		{
			return INVALID_SOCKET;
		}
		memcpy(&sin.sin_addr, hp->h_addr_list[0], sizeof(DWORD));
	}
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s == INVALID_SOCKET) return s;
	WSAAsyncSelect(s, hMainWnd, WM_USER+0x1998, FD_CLOSE | FD_READ | FD_CONNECT);
	connect(s, (struct sockaddr *)&sin, sizeof(sin));
	return s;
}

int Send(SOCKET s, const char *format, ...)
{
	if (format)
	{
		va_list args;
		char buf[8192];

		ZeroMemory(&buf, sizeof(buf));
		va_start(args, format);
		_vsnprintf(buf, sizeof(buf), format, args);
		va_end(args);
		return send(s, buf, lstrlen(buf), 0);
	}
	return 0;
}

void ParseServer(int i, char *buf)
{
	char *end, token1[1024], token2[1024], token3[1024], args[4096], *tokens[3], *comm, *nick, *user, *host;
	int len, count, num;

	if (!buf || !*buf || i == -1) return;
	len = lstrlen(buf);
	end = len + buf;
	if (*--end == '\n') *end-- = 0;
	if (!buf || !*buf) return;
	tokens[0] = token1;
	tokens[1] = token2;
	tokens[2] = token3;
	count = GetTokens(buf, tokens, 3, args);
	comm = token1;
	if (token1[0] == ':')
	{
		char *rest, *to, *from;
		from = token1;
		if (*from == ':') from++;
		comm = token2;
		to = token3;
		if (*to == ':') to++;
		rest = args;
		if (*rest == ':') rest++;
		nick = strtok(from, "!");
		user = strtok(NULL, "@");
		host = strtok(NULL, "");
		if (num = atoi(comm))
		{
			switch(num)
			{
				case 366: break;
				case 001: Put(i, "%s %s\n", header, rest); windows[i].loggedIn = TRUE; break;
				case 002:
				case 003:
				case 004: Put(i, "%s %s\n", header, rest); break;
				case 005:
					{
						char *a, *b, *c;
						a = strtok(rest, " ");
						b = strtok(NULL, " ");
						c = strtok(NULL, "");
						if (*c == ':') c++;
						Put(i, "%s\n", cvt_style("RAW_005", "%s %s %s", a, b, c));
					}
					break;
				case 251: Put(i, "%s %s\n", header, rest); break;
				case 252:
					{
						char *a, *b;
						a = strtok(rest, " ");
						b = strtok(NULL, "");
						if (*b == ':') b++;
						Put(i, "%s\n", cvt_style("RAW_252", "%s", a));
					}
					break;
				case 253:
					{
						char *a, *b;
						a = strtok(rest, " ");
						b = strtok(NULL, "");
						if (*b == ':') b++;
						Put(i, "%s\n", cvt_style("RAW_253", "%s", a));
					}
					break;
				case 254:
					{
						char *a, *b;
						a = strtok(rest, " ");
						b = strtok(NULL, "");
						if (*b == ':') b++;
						Put(i, "%s\n", cvt_style("RAW_254", "%s", a));
					}
					break;
				case 255:
				case 265:
				case 266:
				case 372:
				case 375:
				case 376: Put(i, "%s %s\n", header, rest); break;
				case 305: //No longer away
				case 306: //Now away
					{
						Put(i, "%s %s\n", header, rest);
					}
					break;
				case 301: //PRIVMSG respond when user is away	
					{
						char *a, *b;
						a = strtok(rest, " ");
						b = strtok(NULL, "");
						if (*b == ':')
							b += sizeof(char);
						if (stricmp(windows[i].nick, a))
							Put(i, "%s\00314[\0030a\00315way\00314/\00315%s\00314]\00315 %s\00315\n", a, b);
					}
					break;
				case 309:
					{
						char *a, *b;
						a = strtok(rest, " ");
						b = strtok(NULL, "");
						if (*b == ':')
							b += sizeof(char);
						Put(i, "%s\0030l\00315anguage\00314: \00315%s\00315\n", header, b);
					}
					break;
				case 311:
					{
						char *a, *b, *c, *d;
						a = strtok(rest, " ");
						b = strtok(NULL, " ");
						c = strtok(NULL, " ");
						d = strtok(NULL, " ");
						d = strtok(NULL, "");
						if (*d == ':') d++;
						Put(i, "%s\0030w\00315hois\00314: \00315%s\00314(\00315%s\00314@\00315%s\00314)\00315\n", header, a, b, c);
						Put(i, "%s\0030i\00315rcname\00314: \00315%s\00315\n", header, d);
					}
					break;
				case 312:
					{
						char *a, *b, *c;
						a = strtok(rest, " ");
						b = strtok(NULL, " ");
						c = strtok(NULL, "");
						if (*c == ':') c++;
						Put(i, "%s\0030s\00315erver\00314: \00315%s\00314(\00315%s\00314)\00315\n", header, b, c);
					}
					break;
				case 313:
					{
						char *a, *b;
						a = strtok(rest, " ");
						b = strtok(NULL, "");
						if (*b == ':') b++;
						Put(i, "%s\0030o\00315per\00314: \00315%s %s\00315\n", header, a, b);
					}
					break;
				case 317:
					{
						char *a, *b, *c;
						a = strtok(rest, " ");
						b = strtok(NULL, " ");
						c = strtok(NULL, " ");
						Put(i, "%s\0030i\00315dle\00314: \00315%d seconds\00315\n", header, atoi(b));
						if (*c)
						{
							long l = atol(c);
							Put(i, "%s\0030s\00315ignon\00314: \00315%s", header, ctime(&l));
						}
					}
					break;
				case 318: break;
				case 319:
					{
						char *a, *b;
						a = strtok(rest, " ");
						b = strtok(NULL, "");
						if (*b == ':') b++;
						Put(i, "%s\0030c\00315hannels\00314: \00315%s\00315\n", header, b);
					}
					break;
				case 332:
					{
						char *a, *b;
						a = strtok(rest, " ");
						b = strtok(NULL, "");
						if (*b == ':') b++;
						Put(i, "%s\00314[\0030t\00315opic\00314/\00315%s\00314]\00315 %s\00315\n", header, a, b);
					}
					break;
				case 333:
					{
						char *a, *b, *c;
						long ago;
						a = strtok(rest, " ");
						b = strtok(NULL, " ");
						c = strtok(NULL, "");
						ago = time(0) - atol(c);
						Put(i, "%s\00314[\0030s\00315etby\00314/\00315%s\00314]\00315 %d secs ago\00315\n", header, b, ago);
					}
					break;
				case 353:
					{
						char *a, *b, *c;
						
						a = strtok(rest, " ");
						b = strtok(NULL, " ");
						c = strtok(NULL, "");
						while (*c == ':') c++;
						Put(i, "%s %s\n", header, c);
					}
					break;
				case 401:
					{
						char *a, *b;
						a = strtok(rest, " ");
						b = strtok(NULL, "");
						if (*b == ':') b++;
						Put(i, "%s\n", cvt_style("RAW_401", "%s", a));
					}
					break;
				case 432:
					{
						char *a, *b;
						a = strtok(rest, " ");
						b = strtok(NULL, "");
						if (*b == ':') b++;
						Put(i, "%s\n", cvt_style("RAW_432", "%s", a));
					}
					break;
				case 433:
					{
						char *a;
						a = strtok(rest, " ");
						Put(i, "%s\n", cvt_style("RAW_433", "%s", a));
						if (!windows[i].loggedIn) 
						{
							if (strcmpi(windows[i].nick, cfg.nick2))
							{
								strcpy(windows[i].nick, cfg.nick2);
								Send(windows[i].sock, "NICK %s\r\n", windows[i].nick);
							} else {
								strcat(windows[i].nick, "_");
								Send(windows[i].sock, "NICK %s\r\n", windows[i].nick);
							}
						}
					}
					break;
				case 471:
					{
						char *chan = strtok(rest, " ");
						Put(i, "%s\n", cvt_style("RAW_471", "%s", chan));
					}
					break;
				case 473:
					{
						char *chan = strtok(rest, " ");
						Put(i, "%s\n", cvt_style("RAW_473", "%s", chan));
					}
					break;
				case 474:
					{
						char *chan = strtok(rest, " ");
						Put(i, "%s\n", cvt_style("RAW_474", "%s", chan));
					}
					break;
				case 475:
					{
						char *chan = strtok(rest, " ");
						Put(i, "%s\n", cvt_style("RAW_475", "%s", chan));
					}
					break;
				default: Put(i, "[ndebug:%3d] <%s> %s\n", num, token3, rest); break;
			} 
		} else {
			if (!strcmpi(comm, "INVITE"))
			{
				char *chan = strtok(rest, " ");
				Put(i, "%s\n", cvt_style("INVITE", "%s %s %s %s", nick, user, host, chan));
				strncpy(windows[i].last_invite, chan, sizeof(windows[i].last_invite));
			} else
			if (!strcmpi(comm, "JOIN"))
			{
				Put(i, "%s\n", cvt_style("JOIN", "%s %s %s %s", nick, user, host, to));
//				if (speechOk)
//				{
//					char *pStr;
//					pStr = to;
//					pStr += sizeof(char);
//					Say("%s has joined %s", nick, pStr);
//				}
				if (!strcmpi(windows[i].nick, nick)) 
				{
					AddChannel(i, to);
					windows[i].cchan = FindChannel(i, to);
				}
			} else
			if (!strcmpi(comm, "KICK"))
			{
				char *a, *b;
				a = strtok(rest, " ");
				b = strtok(NULL, "");
				if (*b == ':') b++;
				if (!strcmpi(windows[i].nick, a))
				{
					//AutoRejoin
					if (cfg.autoRejoin)
						Send(windows[i].sock, "JOIN :%s\r\n", to);
					Put(i, "%s\00314[\0030k\00315ick\00314/\00315%s\00314]\00315 you were kicked by %s \00314(\00315%s\00314)\00315\n", header, to, nick, b);
					DestroyChannel(i, to);
				} else {
					Put(i, "%s\00314[\0030k\00315ick\00314/\00315%s\00314]\00315 %s was kicked by %s \00314(\00315%s\00314)\00315\n", header, to, a, nick, b);
				}
			} else
			if (!strcmpi(comm, "MODE"))
			{
				Put(i, "%s\n", cvt_style("MODE_CHANGE", "%s %s %s", nick, to, rest));
			} else
			if (!strcmpi(comm, "NICK"))
			{
				Put(i, "%s\n", cvt_style("NICK_CHANGE", "%s %s", nick, to));
				if (!strcmpi(windows[i].nick, nick))
				{
					strncpy(windows[i].nick, to, sizeof(windows[i].nick));
//					if (speechOk) Say("You are now known as %s", to);
				} else {
//					if (speechOk) Say("%s is now known as %s", nick, to);
				}
			} else
			if (!strcmpi(comm, "NOTICE"))
			{
				if (rest[0] == '\001')
				{
					char *a, *b;
					int len;
					len = lstrlen(rest);
					if (rest[len-1] == '\001') rest[len-1] = 0;
					a = strtok(rest, " ");
					b = strtok(NULL, "");
					if (*a == '\001') a++;
					if (!strcmpi(a, "PING"))
					{
						long secs = time(0) - atol(b);

						Put(i, "%s\00314[\0030c\00315tcp\00314/\00315ping\00314]\00315 reply from %s\00314:\00315 %d secs\00315\n", header, nick, secs);
					} else {
						Put(i, "%s\00314[\0030c\00315tcp\00314/\00315%s\00314]\00315 reply from %s%s %s\00315\n", header, a, nick, *b?"\00314:\00315":"",*b?b:"");
					}
				}
				else
				{
					if (to[0] == '#')
					{
#ifndef DLL
						OSVERSIONINFO os;
#endif
						Put(i, "%s\n", cvt_style("NOTICE_CHANNEL", "%s %s %s %s %s", nick, user, host, to, rest));
#ifndef DLL
						os.dwOSVersionInfoSize = sizeof(os);
						GetVersionEx(&os);

						if ((isTray)&&
							(os.dwPlatformId == VER_PLATFORM_WIN32_NT)&&
							(os.dwMajorVersion >= 5))
						{
							NOTIFYICONDATA50 icondata;
	
							icondata.cbSize =sizeof(NOTIFYICONDATA50);
							icondata.hWnd   =hMainWnd;
							icondata.uID    =1;
							icondata.uFlags =NIF_MESSAGE | NIF_ICON | NIF_INFO;
							icondata.hIcon  =LoadIcon(g_hInst,(const char *)IDI_0IRC_SMALL);
							icondata.uCallbackMessage = CM_TRAYICON;
							strcpy(icondata.szTip,ircname);
							strcat(icondata.szTip," ");
							strcat(icondata.szTip,version);
							if ((windows[currWindow].cchan)&&(windows[currWindow].channels)) {
								strcat(icondata.szTip," - ");
								strcat(icondata.szTip,windows[currWindow].cchan->name);
							}
							//icondata.dwState    =0;
							//icondata.dwStateMask=0;
							strcpy(icondata.szInfo,rest);
							icondata.uTimeout=10;
							strcpy(icondata.szInfoTitle,nick);
							icondata.dwInfoFlags=NIIF_WARNING;

							Shell_NotifyIcon(NIM_MODIFY, &icondata);
						}
#endif
					}
					else
						if (user) {
#ifndef DLL
							OSVERSIONINFO os;
#endif
							Put(i, "%s\n", cvt_style("NOTICE_USER", "%s %s %s %s", nick, user, host, rest));
#ifndef DLL
							os.dwOSVersionInfoSize = sizeof(os);
							GetVersionEx(&os);

							if ((isTray)&&
								(os.dwPlatformId == VER_PLATFORM_WIN32_NT)&&
								(os.dwMajorVersion >= 5))
							{
								NOTIFYICONDATA50 icondata;
		
								icondata.cbSize =sizeof(NOTIFYICONDATA50);
								icondata.hWnd   =hMainWnd;
								icondata.uID    =1;
								icondata.uFlags =NIF_MESSAGE | NIF_ICON | NIF_INFO;
								icondata.hIcon  =LoadIcon(g_hInst,(const char *)IDI_0IRC_SMALL);
								icondata.uCallbackMessage = CM_TRAYICON;
								strcpy(icondata.szTip,ircname);
								strcat(icondata.szTip," ");
								strcat(icondata.szTip,version);
								if ((windows[currWindow].cchan)&&(windows[currWindow].channels)) {
									strcat(icondata.szTip," - ");
									strcat(icondata.szTip,windows[currWindow].cchan->name);
								}
								//icondata.dwState    =0;
								//icondata.dwStateMask=0;
								strcpy(icondata.szInfo,rest);
								icondata.uTimeout=10;
								strcpy(icondata.szInfoTitle,nick);
								icondata.dwInfoFlags=NIIF_WARNING;
	
								Shell_NotifyIcon(NIM_MODIFY, &icondata);
							}
#endif
						} else {
#ifndef DLL
							OSVERSIONINFO os;
#endif
							Put(i, "%s\n", cvt_style("NOTICE_SERVER", "%s %s", nick, rest));
#ifndef DLL
							os.dwOSVersionInfoSize = sizeof(os);
							GetVersionEx(&os);

							if ((isTray)&&
								(os.dwPlatformId == VER_PLATFORM_WIN32_NT)&&
								(os.dwMajorVersion >= 5))
							{
								NOTIFYICONDATA50 icondata;
		
								icondata.cbSize =sizeof(NOTIFYICONDATA50);
								icondata.hWnd   =hMainWnd;
								icondata.uID    =1;
								icondata.uFlags =NIF_MESSAGE | NIF_ICON | NIF_INFO;
								icondata.hIcon  =LoadIcon(g_hInst,(const char *)IDI_0IRC_SMALL);
								icondata.uCallbackMessage = CM_TRAYICON;
								strcpy(icondata.szTip,ircname);
								strcat(icondata.szTip," ");
								strcat(icondata.szTip,version);
								if ((windows[currWindow].cchan)&&(windows[currWindow].channels)) {
									strcat(icondata.szTip," - ");
									strcat(icondata.szTip,windows[currWindow].cchan->name);
								}
								//icondata.dwState    =0;
								//icondata.dwStateMask=0;
								strcpy(icondata.szInfo,rest);
								icondata.uTimeout=10;
								strcpy(icondata.szInfoTitle,nick);
								icondata.dwInfoFlags=NIIF_WARNING;
	
								Shell_NotifyIcon(NIM_MODIFY, &icondata);
							}
#endif
						}

				}
			} else
			if (!strcmpi(comm, "PART"))
			{
				Put(i, "%s\n", cvt_style("PART", "%s %s %s %s", nick, user, host, to));
//				if (speechOk)
//				{
//					char *pStr;
//					pStr = to;
//					pStr += sizeof(char);
//					Say("%s has left %s", nick, pStr);
//				}
				if (!strcmpi(windows[i].nick, nick)) 
				{
					DestroyChannel(i, to);
					windows[i].cchan = windows[i].channels;
				}
			} else
			if (!strcmpi(comm, "PRIVMSG"))
			{
				if (rest[0] == '\001')
				{
					char *a, *b;
					int len;
					len = lstrlen(rest);
					if (rest[len-1] == '\001') rest[len-1] = 0;
					a = strtok(rest, " ");
					b = strtok(NULL, "");
					if (*a == '\001') a++;
					if (!strcmpi(a, "ACTION"))
					{
						Put(i, "\00314. \00315%s %s\n", nick, b);
//						if (speechOk) Say("%s %s", nick, b);
					} else
					if (!strcmpi(a, "DCC"))
					{
						char *type, *arg1, *arg2, *arg3, *arg4;
						type = strtok(b, " ");
						arg1 = strtok(NULL, " ");
						arg2 = strtok(NULL, " ");
						arg3 = strtok(NULL, " ");
						arg4 = strtok(NULL, "");
						if (!strcmpi(type, "SEND"))
						{
							Put(i, "%s\00314[\0030d\00315cc\00314/\00315%s\00314]\00315 request from %s\00314:\00315 %s \00314(\00315%s bytes\00314)\n", header, "send", nick, arg1, arg4);
							Put(i, "%s\00314[\0030i\00315rc\00314/\00315%s\00314]\00315 type \0030/DCC GET %s\00315 to accept.\n", header, "help", nick);
							AddGetDCC(i, nick, arg1, arg2, arg3, arg4);
						} else
						if (!strcmpi(type, "TSEND"))
						{
							Put(i, "%s dcc\00314/\00310%s\00315 request from %s\00314:\00315 %s \00314(\00315%s bytes\00314)\n", header, type, nick, arg1, arg4);
							AddTGetDCC(i, nick, arg1, arg2, arg3, arg4);
						}
					} else
					if (!strcmpi(a, "PAGE"))
					{
						Put(i, "%s\00314[\0030c\00315tcp\00314/\00315page\00314]\00315 request from %s\00315\n", header, nick);
					} else
					if (!strcmpi(a, "PING"))
					{
						Send(windows[i].sock, "NOTICE %s :\001PING %s\001\r\n", nick, b);
						Put(i, "%s\00314[\0030c\00315tcp\00314/\00315ping\00314]\00315 request from %s\00315\n", header, nick);
					} else
					if (!strcmpi(a, "VERSION"))
					{
						OSVERSIONINFO os;
						char *flavor = "";

						os.dwOSVersionInfoSize = sizeof(os);
						GetVersionEx(&os);
						if (os.dwPlatformId == VER_PLATFORM_WIN32s) flavor = "32s";
						else if (os.dwPlatformId == VER_PLATFORM_WIN32_NT)
						{
							if ((os.dwMajorVersion==5)&&(os.dwMinorVersion==0)) flavor = "2000";
							else if ((os.dwMajorVersion==5)&&(os.dwMinorVersion==1)) flavor = "XP";
							else flavor = "NT";
						}
						else if (os.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS && os.dwMinorVersion == 0) flavor = "95";
						else if (os.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS && os.dwMinorVersion > 0) flavor = "98";
						Send(windows[i].sock, "NOTICE %s :\001VERSION %s\001\r\n", nick, cvt_style("VERSION_REPLY", "%s %s %d %d %d", version, flavor, os.dwMajorVersion, os.dwMinorVersion, os.dwPlatformId == VER_PLATFORM_WIN32_NT?os.dwBuildNumber:LOWORD(os.dwBuildNumber)));
						Put(i, "%s\00314[\0030c\00315tcp\00314/\00315version\00314]\00315 request from %s\00315\n", header, nick);
					} else
						Put(i, "%s\00314[\0030c\00315tcp\00314/\00315%s\00314]\00315 request from %s%s %s\00315\n", header, a, nick, b?":":"", b?b:"");
				} else {
					if (to[0] == '#')
					{
						if (windows[i].cchan)
						{
							if (!strcmpi(windows[i].cchan->name, to))
								Put(i, "%s\n", cvt_style("PUBLIC", "%s %s", nick, rest));
							else
								Put(i, "%s\n", cvt_style("PUBLIC_OTHER", "%s %s %s", nick, to, rest));
//							if (speechOk) Say("%s says %s", nick, rest);
						}
					} else {
#ifndef DLL
						OSVERSIONINFO os;
#endif
						Put(i, "%s\n", cvt_style("PRIVMSG", "%s %s %s %s", nick, user, host, rest));
#ifndef DLL
						os.dwOSVersionInfoSize = sizeof(os);
						GetVersionEx(&os);

						if ((isTray)&&
							(os.dwPlatformId == VER_PLATFORM_WIN32_NT)&&
							(os.dwMajorVersion >= 5))
						{
							NOTIFYICONDATA50 icondata;

							icondata.cbSize =sizeof(NOTIFYICONDATA50);
							icondata.hWnd   =hMainWnd;
							icondata.uID    =1;
							icondata.uFlags =NIF_MESSAGE | NIF_ICON | NIF_INFO;
							icondata.hIcon  =LoadIcon(g_hInst,(const char *)IDI_0IRC_SMALL);
							icondata.uCallbackMessage = CM_TRAYICON;
							strcpy(icondata.szTip,ircname);
							strcat(icondata.szTip," ");
							strcat(icondata.szTip,version);
							if ((windows[currWindow].cchan)&&(windows[currWindow].channels)) {
								strcat(icondata.szTip," - ");
								strcat(icondata.szTip,windows[currWindow].cchan->name);
							}
							//icondata.dwState    =0;
							//icondata.dwStateMask=0;
							strcpy(icondata.szInfo,rest);
							icondata.uTimeout=10;
							strcpy(icondata.szInfoTitle,nick);
							icondata.dwInfoFlags=NIIF_INFO;

							Shell_NotifyIcon(NIM_MODIFY, &icondata);
						}
#endif
//						if (speechOk) Say("%s whispers %s", nick, rest);
					}
				}
			} else
			if (!strcmpi(comm, "QUIT"))
			{
				char *a;
				a = token3;
				if (*a == ':') a++;
				Put(i, "%s\00314[\0030s\00315ignoff\00314/\00315%s\00314]\00315 %s %s\00315\n", header, nick, a, *rest?rest:"");
			} else
			if (!strcmpi(comm, "TOPIC"))
			{
				char *a, *b;
				a = token3;
				if (*a == ':') a++;
				b = rest;
				if (*b == ':') b++;
				Put(i, "%s\00314[\0030t\00315opic\00314/\00315%s\00314]\00315 %s\00315\n", header, a, rest);
				Put(i, "%s\00314[\0030s\00315etby\00314/\00315%s\00314]\00315\n", header, nick);
//				if (speechOk) Say("%s sets %s topic to %s", nick, a, b);
			} else
				Put(i, "[debug:%s] <%s> %s\n", comm, token3, rest);
		}
		return;
	}
	{
		char *rest;
		comm = strtok(buf, " ");
		rest = strtok(NULL, "");
		if (*rest == ':') rest++;
		if (!strcmpi(comm, "NOTICE"))
		{
			rest = args;
			if (*rest == '-') rest++;
			Put(i, "%s %s\n", header, rest); 
		} else
		if (!strcmpi(comm, "ERROR"))
		{
			Put(i, "%s\00314[\0030e\00315rror\00314/\00315server\00314]\00315 %s\00315\n", header, rest);
		} else
		if (!strcmpi(comm, "PING")) Send(windows[i].sock, "PONG :%s\r\n", rest);
		else
			Put(i, "[sdebug:%s] %s\n", comm, rest);
	}
}

void DestroyChannels(int num)
{
	channelType *chan;
	
	if (num == -1) return;
	for (chan = windows[num].channels; chan; chan = chan->next)
	{
		free(chan);
	}
	windows[num].channels = NULL;
}

void AddChannel(int num, char *name)
{
	if (num == -1) return;
	if (windows[num].channels == NULL)
	{
		windows[num].channels = (channelType *)malloc(sizeof(channelType));
		windows[num].channels->prev = NULL;
		windows[num].channels->next = NULL;
		strcpy(windows[num].channels->name, name);
	} else {
		channelType *chan = windows[num].channels;

		while (chan->next) chan = chan->next;
		chan->next = (channelType *)malloc(sizeof(channelType));
		chan->next->prev = chan;
		chan = chan->next;
		chan->next = NULL;
		strcpy(chan->name, name);
	}
}

void DestroyChannel(int num, char *name)
{
	channelType *chan = FindChannel(num, name);

	if (chan)
	{
		if (!chan->next)
		{
			if (chan->prev)
			{
				chan->prev->next = NULL;
			}
			free(chan);
			if (chan == windows[num].channels) windows[num].channels = NULL;
		} else {
			if (chan->prev)
			{
				chan->prev->next = chan->next;
				chan->next->prev = chan->prev;
			} else {
				chan->next->prev = NULL;
			}
			if (chan == windows[num].channels) windows[num].channels = chan->next;
			free(chan);
		}
	}
}

channelType *FindChannel(int num, char *name)
{
	channelType *chan;

	if (num == -1) return NULL;
	for (chan = windows[num].channels; chan; chan = chan->next)
	{
		if (!strcmpi(chan->name, name))
			return (channelType *)chan;
	}

	return NULL;
}

#ifdef DLL
void LoadConfig()
{
	ZeroMemory(&cfg, sizeof(configType));
	GetRCString("0ircNickname", (char *)cfg.nick, "Nickname", sizeof(cfg.nick));
	GetRCString("0ircAltNickname", (char *)cfg.nick2, "Nickname_", sizeof(cfg.nick2));
	GetRCString("0ircUsername", (char *)cfg.username, "user", sizeof(cfg.username));
	GetRCString("0ircDescription", (char *)cfg.desc, "0irc", sizeof(cfg.desc));
	GetRCString("0ircServer", (char *)cfg.server, "irc.dal.net", sizeof(cfg.server));

	cfg.dccBlockSize = GetRCInt("0ircDCCBlockSize", 4096);
	cfg.dccOverrideLocalhost = GetRCBool("0ircDCCOverrideLocalhost", TRUE);
	GetRCString("0ircDCCOverrideHost", (char *)cfg.dccOverrideHost, "", sizeof(cfg.dccOverrideHost));
	GetRCString("0ircDCCReceivePath", (char *)cfg.dccReceivePath, "", sizeof(cfg.dccReceivePath));

    cfg.windowpos.left=GetRCInt("0ircWindowLeft", 100);
    cfg.windowpos.top=GetRCInt("0ircWindowTop", 100);
    cfg.windowpos.right=cfg.windowpos.left+GetRCInt("0ircWindowWidth", 640);
    cfg.windowpos.bottom=cfg.windowpos.top+GetRCInt("0ircWindowHeight", 480);

	cfg.timeStamp = GetRCBool("0ircTimeStamp", TRUE);
	cfg.time24hour = GetRCBool("0irc24HourTime", TRUE);
	cfg.autoRejoin = GetRCBool("0ircAutoRejoin", TRUE);
	cfg.pager = GetRCBool("0ircPager", TRUE);
	//cfg.autoAway = GetRCBool("0ircAutoAway", TRUE);
	cfg.autoAwayTime = GetRCInt("0ircAutoAwayTime", 0);
	cfg.autoAway = (cfg.autoAwayTime>0);
	cfg.executeLSCommands = GetRCBool("0ircNoBangCommands", FALSE);

	cfg.windowvisible = GetRCBool("0ircHiddenStartup", FALSE);
	GetRCString("0ircTabPixmap", (char *)cfg.tabPixmap, "", sizeof(cfg.tabPixmap));
	GetRCString("0ircTabIcon", (char *)cfg.tabIcon, "", sizeof(cfg.tabIcon));

	cfg.editColor=GetRCColor("0ircEditColor", RGB(0,0,0));
	cfg.textColor=GetRCColor("0ircTextColor", RGB(192,192,192));
	cfg.frameColor=GetRCColor("0ircFrameColor", GetSysColor(COLOR_3DFACE));
}
#else
void LoadConfig(char *ini)
{
	ZeroMemory(&cfg, sizeof(configType));
	GetPrivateProfileString("User", "Nickname", "Nickname", (char *)cfg.nick, sizeof(cfg.nick), ini);
	GetPrivateProfileString("User", "AltNickname", "Nickname_", (char *)cfg.nick2, sizeof(cfg.nick2), ini);
	GetPrivateProfileString("User", "Username", "user", (char *)cfg.username, sizeof(cfg.username), ini);
	GetPrivateProfileString("User", "Description", "0irc", (char *)cfg.desc, sizeof(cfg.desc), ini);
	GetPrivateProfileString("User", "Server", "irc.dal.net", (char *)cfg.server, sizeof(cfg.server), ini);
//	GetPrivateProfileString("User", "Logfilename", "", (char *)cfg.logfilename, sizeof(cfg.logfilename), ini);

	cfg.dccBlockSize = GetPrivateProfileInt("DCC", "BlockSize", 4096, ini);
	cfg.dccOverrideLocalhost = GetPrivateProfileInt("DCC", "OverrideLocalhost", FALSE, ini);
	GetPrivateProfileString("DCC", "OverrideHost", "", (char *)cfg.dccOverrideHost, sizeof(cfg.dccOverrideHost), ini);
	GetPrivateProfileString("DCC", "ReceivePath", "", (char *)cfg.dccReceivePath, sizeof(cfg.dccReceivePath), ini);

    cfg.windowpos.left=GetPrivateProfileInt("Window", "left", 100, ini);
    cfg.windowpos.top=GetPrivateProfileInt("Window", "top", 100, ini);
    cfg.windowpos.right=cfg.windowpos.left+GetPrivateProfileInt("Window", "width", 640, ini);
    cfg.windowpos.bottom=cfg.windowpos.top+GetPrivateProfileInt("Window", "height", 480, ini);

//	cfg.speechActive = GetPrivateProfileInt("Speech", "Active", FALSE, ini);
//	cfg.speechPublic = GetPrivateProfileInt("Speech", "Public Text", TRUE, ini);
//	cfg.speechAction = GetPrivateProfileInt("Speech", "Actions", TRUE, ini);
//	cfg.speechPrivate = GetPrivateProfileInt("Speech", "Private Messages", TRUE, ini);
//	cfg.speechCtcp = GetPrivateProfileInt("Speech", "CTCP Requests", TRUE, ini);
//	cfg.speechNotifyOn = GetPrivateProfileInt("Speech", "Notify Signon", TRUE, ini);
//	cfg.speechNotifyOff = GetPrivateProfileInt("Speech", "Notify Signoff", TRUE, ini);
//	cfg.speechJoin = GetPrivateProfileInt("Speech", "Join", TRUE, ini);
//	cfg.speechPart = GetPrivateProfileInt("Speech", "Part", TRUE, ini);
//	cfg.speechSignoff = GetPrivateProfileInt("Speech", "Signoff", TRUE, ini);
//	cfg.speechTopic = GetPrivateProfileInt("Speech", "Topic", TRUE, ini);
//	cfg.speechInvite = GetPrivateProfileInt("Speech", "Invite", TRUE, ini);
//	cfg.speechNick = GetPrivateProfileInt("Speech", "Nickname", TRUE, ini);

	cfg.timeStamp = GetPrivateProfileInt("Options", "TimeStamp", FALSE, ini);
	cfg.time24hour = GetPrivateProfileInt("Options", "24HourTime", FALSE, ini);
	cfg.autoRejoin = GetPrivateProfileInt("Options", "AutoRejoin", FALSE, ini);
	cfg.pager = GetPrivateProfileInt("Options", "Pager", TRUE, ini);
	cfg.autoAway = GetPrivateProfileInt("Options", "AutoAway", FALSE, ini);
	cfg.autoAwayTime = GetPrivateProfileInt("Options", "AutoAwayTime", 10, ini);
}

void SaveConfig(char *ini)
{
	char temp[26];

	WritePrivateProfileString("User", "Nickname", cfg.nick, ini);
	WritePrivateProfileString("User", "AltNickname", cfg.nick2, ini);
	WritePrivateProfileString("User", "Username", cfg.username, ini);
	WritePrivateProfileString("User", "Description", cfg.desc, ini);
	WritePrivateProfileString("User", "Server", cfg.server, ini);
	wsprintf(temp, "%d", cfg.dccBlockSize);
	WritePrivateProfileString("DCC", "BlockSize", temp, ini);
	wsprintf(temp, "%d", cfg.dccOverrideLocalhost);
	WritePrivateProfileString("DCC", "OverrideLocalhost", temp, ini);
	WritePrivateProfileString("DCC", "OverrideHost", cfg.dccOverrideHost, ini);
	WritePrivateProfileString("DCC", "ReceivePath", cfg.dccReceivePath, ini);

//	wsprintf(temp, "%d", cfg.speechActive);
//	WritePrivateProfileString("Speech", "Active", temp, ini);
//	wsprintf(temp, "%d", cfg.speechPublic);
//	WritePrivateProfileString("Speech", "Public Text", temp, ini);
//	wsprintf(temp, "%d", cfg.speechAction);
//	WritePrivateProfileString("Speech", "Actions", temp, ini);
//	wsprintf(temp, "%d", cfg.speechPrivate);
//	WritePrivateProfileString("Speech", "Private Messages", temp, ini);
//	wsprintf(temp, "%d", cfg.speechCtcp);
//	WritePrivateProfileString("Speech", "CTCP Requests", temp, ini);
//	wsprintf(temp, "%d", cfg.speechNotifyOn);
//	WritePrivateProfileString("Speech", "Notify Signon", temp, ini);
//	wsprintf(temp, "%d", cfg.speechNotifyOff);
//	WritePrivateProfileString("Speech", "Notify Signoff", temp, ini);
//	wsprintf(temp, "%d", cfg.speechJoin);
//	WritePrivateProfileString("Speech", "Join", temp, ini);
//	wsprintf(temp, "%d", cfg.speechPart);
//	WritePrivateProfileString("Speech", "Part", temp, ini);
//	wsprintf(temp, "%d", cfg.speechSignoff);
//	WritePrivateProfileString("Speech", "Signoff", temp, ini);
//	wsprintf(temp, "%d", cfg.speechTopic);
//	WritePrivateProfileString("Speech", "Topic", temp, ini);
//	wsprintf(temp, "%d", cfg.speechInvite);
//	WritePrivateProfileString("Speech", "Invite", temp, ini);
//	wsprintf(temp, "%d", cfg.speechNick);
//	WritePrivateProfileString("Speech", "Nickname", temp, ini);

	wsprintf(temp, "%d", cfg.timeStamp);
	WritePrivateProfileString("Options", "TimeStamp", temp, ini);
	wsprintf(temp, "%d", cfg.time24hour);
	WritePrivateProfileString("Options", "24HourTime", temp, ini);
	wsprintf(temp, "%d", cfg.autoRejoin);
	WritePrivateProfileString("Options", "AutoRejoin", temp, ini);
	wsprintf(temp, "%d", cfg.pager);
	WritePrivateProfileString("Options", "Pager", temp, ini);
	wsprintf(temp, "%d", cfg.autoAway);
	WritePrivateProfileString("Options", "AutoAway", temp, ini);
	wsprintf(temp, "%d", cfg.autoAwayTime);
	WritePrivateProfileString("Options", "AutoAwayTime", temp, ini);
}

void SaveConfigPos(char *ini)
{
	char temp[26];

	wsprintf(temp, "%d", cfg.windowpos.left);
	WritePrivateProfileString("Window", "left", temp, ini);
	wsprintf(temp, "%d", cfg.windowpos.top);
	WritePrivateProfileString("Window", "top", temp, ini);
	wsprintf(temp, "%d", cfg.windowpos.right-cfg.windowpos.left);
	WritePrivateProfileString("Window", "width", temp, ini);
	wsprintf(temp, "%d", cfg.windowpos.bottom-cfg.windowpos.top);
	WritePrivateProfileString("Window", "Height", temp, ini);
}
#endif

void StartIdentd()
{
	struct sockaddr_in sin;

	sin.sin_family = AF_INET;
	sin.sin_port = htons(113);
	sin.sin_addr.s_addr = INADDR_ANY;
	identSock = socket(AF_INET, SOCK_STREAM, 0);
	if (identSock == INVALID_SOCKET) return;
	if (bind(identSock, (struct sockaddr *)&sin, sizeof(sin)) == SOCKET_ERROR) 
	{
		closesocket(identSock);
		return;
	}
	if (listen(identSock, 1))
	{
		closesocket(identSock);
		return;
	}
	WSAAsyncSelect(identSock, hMainWnd, WM_USER+0x2000, FD_READ | FD_ACCEPT);
}

void StopIdentd()
{
	closesocket(identSock);
	ZeroMemory(&identBuf, sizeof(identBuf));
	identPos = 0;
}
