/* 0irc
 * Copyright (C) 2000-2001 Torsten Stelling <murphy@dev0.de>
 *
 * AuroreIRC
 * Copyright (C) 1999 Omar Kilani <omar@aurore.net>
 *
 * OpenIRC
 * Copyright (C) 1998 Damian Hodgkiss <mian@thrity4.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <winsock.h>
#include "irc.h"

void DestroyDCCs(int num)
{
	channelType *chan;
	
	if (num == -1) return;
	for (chan = windows[num].channels; chan; chan = chan->next)
	{
		free(chan);
	}
	windows[num].channels = NULL;
}

void AddDCC(int num, char *name)
{
	if (num == -1) return;
	if (windows[num].dcc == NULL)
	{
		windows[num].dcc = (dccType *)malloc(sizeof(dccType));
		windows[num].dcc->prev = NULL;
		windows[num].dcc->next = NULL;
		strcpy(windows[num].dcc->nick, name);
	} else {
		dccType *dcc = windows[num].dcc;

		while (dcc->next) dcc = dcc->next;
		dcc->next = (dccType *)malloc(sizeof(dccType));
		dcc->next->prev = dcc;
		dcc = dcc->next;
		dcc->next = NULL;
		strcpy(dcc->nick, name);
	}
}

void DestroyDCC(int num, char *name)
{
	dccType *dcc = FindDCC(num, name);

	if (dcc)
	{
		if (!dcc->next)
		{
			if (dcc->prev)
			{
				dcc->prev->next = NULL;
			}
			free(dcc);
			if (dcc == windows[num].dcc) windows[num].dcc = NULL;
		} else {
			if (dcc->prev)
			{
				dcc->prev->next = dcc->next;
				dcc->next->prev = dcc->prev;
			} else {
				dcc->next->prev = NULL;
			}
			if (dcc == windows[num].dcc) windows[num].dcc = dcc->next;
			free(dcc);
		}
	}
}

dccType *FindDCC(int num, char *name)
{
	dccType *dcc;

	if (num == -1) return NULL;
	for (dcc = windows[num].dcc; dcc; dcc = dcc->next)
	{
		if (!strcmpi(dcc->nick, name))
			return (dccType *)dcc;
	}

	return NULL;
}

void AddGetDCC(int num, char *nick, char *name, char *ip, char *port, char *size)
{
	dccType *dcc;

	AddDCC(num, nick);
	if (dcc = FindDCC(num, nick))
	{
		strcpy(dcc->file, name);
		dcc->type = DCC_GET;
		dcc->start = 0;
		dcc->len = atol(size);
		dcc->read = 0;
		dcc->sin.sin_family = AF_INET;
		dcc->sin.sin_port = htons(atoi(port));
		dcc->sin.sin_addr.s_addr = htonl(atol(ip));
	}
}

void AddTGetDCC(int num, char *nick, char *name, char *ip, char *port, char *size)
{
	dccType *dcc;

	AddDCC(num, nick);
	if (dcc = FindDCC(num, nick))
	{
		strcpy(dcc->file, name);
		dcc->type = DCC_TGET;
		dcc->start = 0;
		dcc->len = atol(size);
		dcc->read = 0;
		dcc->sin.sin_family = AF_INET;
		dcc->sin.sin_port = htons(atoi(port));
		dcc->sin.sin_addr.s_addr = htonl(atol(ip));
	}
}

void AddSendDCC(int num, char *nick, char *name, char *ip, char *port, char *size)
{
	dccType *dcc;

	AddDCC(num, nick);
	if (dcc = FindDCC(num, nick))
	{
		strcpy(dcc->file, name);
		dcc->type = DCC_SEND;
		dcc->start = 0;
		dcc->len = atol(size);
		dcc->read = 0;
		dcc->sin.sin_family = AF_INET;
		dcc->sin.sin_port = htons(atoi(port));
		dcc->sin.sin_addr.s_addr = htonl(atol(ip));
	}
}