/* 0irc
 * Copyright (C) 2000-2001 Torsten Stelling <murphy@dev0.de>
 *
 * AuroreIRC
 * Copyright (C) 1999 Omar Kilani <omar@aurore.net>
 *
 * OpenIRC
 * Copyright (C) 1998 Damian Hodgkiss <mian@thrity4.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <process.h>
#include <commctrl.h>
#include "commands.h"
#include "irc.h"
#ifdef DLL
#include "0ircdll/litestep/lsapi.h"
//#include "0ircdll/litestep/wharfdata.h"
#endif

extern char *cvt_style(const char *format, ...);

commandType commands[] = {
	{ "ABOUT", About },
	{ "AME", Ame },
	{ "AWAY", Away },
	{ "A", Away },
	{ "CHANNELS", Channels },
	{ "CLEAR", Clear },
	{ "CTCP", Ctcp },
#ifndef DLL
	{ "CONFIG", CmdConfig },
#endif
	{ "CONNECT", CmdConnect },
	{ "C", CmdConnect },
	{ "DCC", Dcc },
	{ "DISCONNECT", CmdDisconnect },
	{ "D", CmdDisconnect },
	{ "ECHO",	Echo },
	{ "FINGER",	CmdFinger },
	{ "F",	CmdFinger },
	{ "HELP",	Help },
	{ "?",	Help },
	{ "JOIN",	Join },
	{ "J", Join },
	{ "KICK", Kick },
	{ "K", Kick },
	{ "LEAVE", Leave },
	{ "L", Leave },
	{ "LOG", CmdLog },
	{ "ME", Me },
	{ "MODE", Mode },
	{ "MSG", Msg },
	{ "M", Msg },
	{ "NICK", Nick },
	{ "NOTICE", Notice },
//	{ "NSLOOKUP", NsLookup },
#ifndef DLL
	{ "QUIT",	Quit },
	{ "Q", Quit },
#endif
	{ "QUOTE", Quote },
	{ "PART", Leave },
	{ "P", Leave },
	{ "PING", Ping },
	{ "SAY", Sayit },
	{ "SERVER", Server },
	{ "S", Server },
	{ "STYLE", Style },
	{ "SV", Sv },
	{ "TOPIC", Topic },
	{ "T", Topic },
#ifndef DLL
	{ "TRAY", CmdTray },
#endif
	{ "WHOIS", Whois },
	{ "W", Whois },
	{ "WINDOW", Window },
//	{ "JOINWIN", JoinWin },
};

#define MAX_COMMANDS	(sizeof(commands) / sizeof(commandType))

void Usage(int num, char *usage)
{
	Put(num, "%s \00314[\0030u\00315sage\00314]\00315 %s\00315\n", header, usage);
}

void ParseLocalCommand(char *command, char *args)
{
	register int i;

#ifdef DLL
	if (command[0]=='!') {
		if (!strcmpi(command,"!quit")) {
			Put(currWindow, "%s \00314[\00315Litestep Error\00314]\00315 !QUIT does not function in 0irc-dll.\n", header);
		} else {
			ParseBangCommand(0, command, args);
		}
/*		LMBANGCOMMAND bcBangCommand;

		bcBangCommand.cbSize=sizeof(bcBangCommand);
		bcBangCommand.hWnd=0;
		_tcscpy(bcBangCommand.szCommand, command);
		_tcscpy(bcBangCommand.szArgs, args);
		PostMessage(GetLitestepWnd(),LM_BANGCOMMAND,sizeof(LMBANGCOMMAND),(LPARAM)&bcBangCommand);
*/
		return;
	}
#endif

	for (i = 0; i < MAX_COMMANDS; i++)
	{
		if (!strcmpi(commands[i].name, command))
		{
			commands[i].func(args);
			return;
		}
	}
	Put(currWindow, "%s No such command: %s\n", header, strupr(command));
}
 
void Ame(char *args)
{
	if (strcmpi(args, ""))
	if (args)
	{
		if (windows[currWindow].cchan == NULL)
			Put(currWindow, "%s You are not on any channels\n", header);
		else {
			channelType *chan;
			Put(currWindow, ". %s %s\n", windows[currWindow].nick, args);
			for (chan = windows[currWindow].channels; chan; chan = chan->next)
			{
				Send(windows[currWindow].sock, "PRIVMSG %s :\001ACTION %s\001\r\n", chan->name, args);
			}
		}
	} else
		Usage(currWindow, "\00314/\00315ame \00314<\00315action\00314>");
	else
		Usage(currWindow, "\00314/\00315ame \00314<\00315action\00314>");
}

void Channels(char *args)
{
	channelType *chan;

	if (windows[currWindow].cchan == NULL)
		Put(currWindow, "%s You are not on any channels\n", header);
	else {
		for (chan = windows[currWindow].channels; chan; chan = chan->next)
		{
			Put(currWindow, "%s %s\n", header, chan->name);
		}
	}
}

void Ctcp(char *args)
{
	char *a, *b, *c;

	a = strtok(args, " ");
	if (!a){
		Usage(currWindow, "\00314/\00315ctcp <\00315nick\00314> <\00315type\00314>");
		return;
	}
	b = strtok(NULL, " ");
	if (!b){
		Usage(currWindow, "\00314/\00315ctcp <\00315nick\00314> <\00315type\00314>");
		return;
	}
	c = strtok(NULL, "");

	if (stricmp(b, "PING") == 0)
	{
		Ping(a);
	}
	else
	{
		if (c != NULL)
			Send(windows[currWindow].sock, "PRIVMSG %s :\001%s%s\001\r\n", a, b, c);
		else
			Send(windows[currWindow].sock, "PRIVMSG %s :\001%s\001\r\n", a, b);
	}
}

void Dcc(char *args)
{
	char *a, *b, *c;

	a = strtok(args, " ");
	if (!a)
	{
		Usage(currWindow, "\00314/\00315dcc \00314<\00315get\00314|\00315tget\00314|\00315send\00314> <\00315nick\00314> <\00315file\00314>");
		return;
	}
	if (!strcmpi(a, "GET"))
	{
		dccType *dcc;
		char path[MAX_PATHLEN];

		b = strtok(NULL, "");
		dcc = FindDCC(currWindow, b);
		if (dcc)
		{
			strcpy(path, cfg.dccReceivePath);
			if (path[lstrlen(path)-1] != '\\') strcat(path, "\\");
			strcat(path, dcc->file);
			if (dcc->type & DCC_GET)
			{
				dcc->sock = socket(AF_INET, SOCK_STREAM, 0);
				if (connect(dcc->sock, (struct sockaddr *)&dcc->sin, sizeof(dcc->sin)) == SOCKET_ERROR)
				{
					DestroyDCC(currWindow, b);
				}
			} else
			if (dcc->type & DCC_TGET)
			{
				dcc->sock = socket(AF_INET, SOCK_DGRAM, 0);
			}
			Put(currWindow, "%s\00314[\0030d\00315cc\00314/\00315get\00314]\00315 from %s established \00314[\00315%s\00314(\00315%d\00314)]\00315\n", header, dcc->nick, inet_ntoa(dcc->sin.sin_addr), ntohs(dcc->sin.sin_port));
			dcc->start = time(0);
			dcc->handle = CreateFile(path, GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_ALWAYS,
				FILE_ATTRIBUTE_NORMAL, NULL);
			WSAAsyncSelect(dcc->sock, hMainWnd, WM_USER+0x1999, FD_CLOSE | FD_READ);
		}
	} else
	if (!strcmpi(a, "SEND"))
	{
		dccType *dcc;
		HANDLE handle;

		b = strtok(NULL, " ");
		if (!b) {
			Usage(currWindow, "\00314/\00315dcc \00314<\00315send\00314> <\00315nick\00314> <\00315file\00314>");
			return;
		}
		c = strtok(NULL, "");
		if (!c) {
			Usage(currWindow, "\00314/\00315dcc \00314<\00315send\00314> <\00315nick\00314> <\00315file\00314>");
			return;
		}
		handle = CreateFile(c, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_ALWAYS,
			FILE_ATTRIBUTE_NORMAL, NULL);
		if (!handle)
		{
			Put(currWindow, "cant open %s\n", c);
			return;
		}
		CloseHandle(handle);
		AddDCC(currWindow, b);
		if (dcc = FindDCC(currWindow, b))
		{
			struct hostent *hp;
			char host[MAX_HOSTLEN];
			int res, port = 1024;
			DWORD fsizeHigh, fsizeLow;
			long fsize;

			strcpy(dcc->file, c);
			dcc->type = DCC_SEND;
			dcc->start = time(0);
			dcc->wrote = 0;
			dcc->sin.sin_family = AF_INET;
			dcc->sin.sin_port = htons(port);
			gethostname((char *)host, sizeof(host));
			dcc->sin.sin_addr.s_addr = inet_addr(host);
			if (dcc->sin.sin_addr.s_addr == INADDR_NONE)
			{
				hp = gethostbyname(host);
				if (hp == NULL)
				{
					return;
				}
				memcpy(&dcc->sin.sin_addr, hp->h_addr_list[0], sizeof(DWORD));
			}
			dcc->sock = socket(AF_INET, SOCK_STREAM, 0);
			while ((res = bind(dcc->sock, (struct sockaddr *)&dcc->sin, sizeof(dcc->sin)) == SOCKET_ERROR)&&(port < 65535))
			{
				port++;
				dcc->sin.sin_port = htons(port);
			}
			if (res == SOCKET_ERROR) 
			{
				closesocket(dcc->sock);
				Put(currWindow, "error finding socket\n");
				return;
			}
			if (listen(dcc->sock, 1))
			{
				closesocket(dcc->sock);
				Put(currWindow, "error listening socket\n");
				return;
			}
			dcc->handle = CreateFile(c, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_ALWAYS,
				FILE_ATTRIBUTE_NORMAL, NULL);
			fsizeHigh = 0;
			fsizeLow = GetFileSize(dcc->handle, NULL);
			if (fsizeLow == 0xFFFFFFFF) fsizeLow = GetFileSize(dcc->handle, &fsizeHigh);
			fsize = (long)(fsizeLow);
			dcc->len = fsize;
			Send(windows[currWindow].sock, "PRIVMSG %s :\001DCC SEND %s %lu %d %lu\001\r\n", b, c, ntohl(dcc->sin.sin_addr.s_addr), ntohs(dcc->sin.sin_port), dcc->len);
			WSAAsyncSelect(dcc->sock, hMainWnd, WM_USER+0x1999, FD_READ | FD_ACCEPT | FD_WRITE);
		}
	}
}

void Echo(char *args)
{
	Put(currWindow, "%s\n", args);
}

void Help(char *args)
{
	int i;
	int j;

	if (!strcmpi(args,"")) {
		Put(currWindow, "%s\n", header);
		Put(currWindow, "%s \00314[\00315known commands\00314]\00315\n", header);
		Put(currWindow, "%s ", header);
		j=0;
		for (i = 0; i < MAX_COMMANDS; i++)
		{
			//Put(currWindow, "%s %s\n", header, commands[i].name);
			if (strlen(commands[i].name)!=1) {
				PutNoTime(currWindow, "%s", commands[i].name);
				j++;
				if (i+1<MAX_COMMANDS) {
					if (strlen(commands[i+1].name)==1)
						PutNoTime(currWindow, " (%s)", commands[i+1].name);
				}
				if ((j<5)&&(i+1<MAX_COMMANDS)) PutNoTime(currWindow, ", ");
			}
			if ((j>=5)&&(i+1<MAX_COMMANDS))
			{
				PutNoTime(currWindow, "\n");
				Put(currWindow, "%s ", header); 
				j=0; 
			}
		}
		PutNoTime(currWindow, "\n");
		Put(currWindow, "%s\n", header);
	} else {
//		if (*args == "/") args++;
		if (!strcmpi(args,"help")||!strcmpi(args,"?")) {
			// help for help here...
			Usage(currWindow, "\00314/\00315help");
			Usage(currWindow, "\00314/\00315help \00314<\00315command\00314>\00315");
			Put(currWindow, "%s \00314[\00315alias\00314]\00315 \00314/\00315?\n", header);
			Put(currWindow, "%s This command displays all commands supported by 0irc, or a specific help for\n", header);
			Put(currWindow, "%s one command.\n", header);
#ifndef DLL
		} else if (!strcmpi(args,"quit")) {
			Usage(currWindow, "\00314/\00315quit");
			Put(currWindow, "%s \00314[\00315alias\00314]\00315 \00314/\00315q\n", header);
			Put(currWindow, "%s Quits 0irc.\n", header);
#endif
		} else {
			Put(currWindow, "%s \00314[\00315help for '%s' not supported in this build\00314]\00315\n", header, args);
		}
	}
}

void Join(char *args)
{
	channelType *chan = FindChannel(currWindow, args);
	if (chan)
	{
		windows[currWindow].cchan = chan;
		Put(currWindow, "%s You are now talking in %s\n", header, windows[currWindow].cchan->name);
	} else {
		if (*args == '#')
			Send(windows[currWindow].sock, "JOIN :%s\r\n", args);
		else
			Send(windows[currWindow].sock, "JOIN :#%s\r\n", args);
	}
}

void Kick(char *args)
{
	char token1[26], *tokens[1], rest[128];
	ZeroMemory(&token1, sizeof(token1));
	tokens[0] = token1;
	GetTokens(args, tokens, 1, rest);
	if (strcmpi(token1, "")) {
		Send(windows[currWindow].sock, "KICK %s %s :%s\r\n", windows[currWindow].cchan->name, token1,
			rest[0]?rest:"Cya!");
	} else {
		Usage(currWindow, "\00314/\00315kick <\00315nick\00314> <\00315reason\00314>");
	}
}

void Leave(char *args)
{
	if (*args)
	{
		if (*args == '#')
			Send(windows[currWindow].sock, "PART :%s\r\n", args);
		else
			Send(windows[currWindow].sock, "PART :#%s\r\n", args);
	} else if (windows[currWindow].cchan)
		Send(windows[currWindow].sock, "PART :%s\r\n", windows[currWindow].cchan->name);
	else
		Put(currWindow, "%s You are not on any channels\n", header);
}

void Me(char *args)
{
	if (strcmpi(args, ""))
	if (args)
	{
		if (windows[currWindow].cchan == NULL)
			Put(currWindow, "%s You are not on any channels\n", header);
		else {
			Send(windows[currWindow].sock, "PRIVMSG %s :\001ACTION %s\001\r\n", windows[currWindow].cchan->name, args);
			Put(currWindow, ". %s %s\n", windows[currWindow].nick, args);
		}
	} else
		Usage(currWindow, "\00314/\00315me \00314<\00315action\00314>");
	else
		Usage(currWindow, "\00314/\00315me \00314<\00315action\00314>");
}

void Mode(char *args)
{
	char *a, *b;
    /* there was a *c as well, not used. */

	a = strtok(args, " ");
	b = strtok(NULL, "");

	if (a && b)
		Send(windows[currWindow].sock, "MODE %s %s\r\n", a, b);
	else
		Usage(currWindow, "\00314/\00315mode \00314<\00315#channel\00314> <\00315mode\00314>");
}

void Msg(char *args)
{
	char *a, *b;

	a = strtok(args, " ");
	b = strtok(NULL, "");
	if (a && b)
	{
		Send(windows[currWindow].sock, "PRIVMSG %s :%s\r\n", a, b);
		Put(currWindow, "%s\00314[\0030m\00315sg\00314(\00315%s\00314)]\00315 %s\00315\n", header, a, b);
	} else
		Usage(currWindow, "\00314/\00315msg \00314<\00315nick\00314|\00315#channel\00314> <\00315text\00314>");
}

void Nick(char *args)
{
	char *nick = strtok(args, " ");
	if (nick)
		Send(windows[currWindow].sock, "NICK :%s\r\n", args);
	else
		Usage(currWindow, "\00314/\00315nick \00314<\00315nick\00314>");
}

void Ping(char *args)
{
	char *a;

	a = strtok(args, " ");
	Send(windows[currWindow].sock, "PRIVMSG %s :\001PING %lu\001\r\n", a, time(0));
}

#ifndef DLL
void Quit(char *args)
{
	if (!strcmpi(args,"/?"))
		Help("quit");
	else {
		Send(windows[currWindow].sock, "QUIT :%s\r\n", *args?args:"Leaving");
		SaveConfig(ircconfig);
		SendMessage(hMainWnd, WM_SYSCOMMAND, SC_CLOSE, 0);
	}
}
#endif

void Server(char *args)
{
	char *server, *pass, *port;
	int p = 6667;
	server = strtok(args, " ");
	port = strtok(NULL, " ");
	pass = strtok(NULL, "");
	if (port) p = atoi(port);
	if (server)
	{
		Send(windows[currWindow].sock, "QUIT :Changing Servers\r\n");
		closesocket(windows[currWindow].sock);
		ZeroMemory(&windows[currWindow].buf, sizeof(windows[currWindow].buf));
		ZeroMemory(&windows[numWindows].last_invite, sizeof(windows[numWindows].last_invite));
		windows[currWindow].bufpos = 0;
		windows[currWindow].lag = 0;
		windows[currWindow].cchan = NULL;
		windows[currWindow].loggedIn = FALSE;
		windows[currWindow].idle = 0;
		windows[currWindow].setAway = 0;
		DestroyChannels(currWindow);
		windows[currWindow].sock = ConnectToServer(server, p);
	} else
		Usage(currWindow, "\00314/\00315server \00314<\00315server\00314> [\00315port\00314] [\00315pass\00314]");
}

void Topic(char *args)
{
	if (windows[currWindow].cchan)
		Send(windows[currWindow].sock, "TOPIC %s :%s\r\n", windows[currWindow].cchan->name, args);
	else
		Put(currWindow, "%s You are not on any channels\n", header);
}

void Whois(char *args)
{
	char *who = strtok(args, "");
	if (who)
		Send(windows[currWindow].sock, "WHOIS %s\r\n", args);
	else
		Usage(currWindow, "\00314/\00315whois \00314<\00315nick\00314>");
}

void Window(char *args)
{
	char token1[26], token2[26], *tokens[2], rest[128];
	ZeroMemory(&token1, sizeof(token1));
	ZeroMemory(&token2, sizeof(token2));
	tokens[0] = token1;
	tokens[1] = token2;
	GetTokens(args, tokens, 2, rest);
	if (!strcmpi(token1, "NEW"))
	{
		CreateNewWindow(*tokens[1]?token2:"new window");
	}
	else if (!strcmpi(token1, "CLOSE"))
	{
		CloseIrcWindow();
	}
	else if (!strcmpi(token1, "LIST"))
	{
		int i;
		for (i = 0; i < numWindows; i++)
		{
			Put(currWindow, "%s [%d] %s\n", header, i+1, windows[i].name);
		}
	}
	else if (strcmpi(token1, ""))
	{
		int i;
		for (i=0; i<numWindows;i++)
			if (!strcmpi(token1,windows[i].name))
			{
				// change to window here...
				TabCtrl_SetCurFocus(hTabWnd, i);
				TabCtrl_SetCurSel(hTabWnd, i);
				SendMessage(hMainWnd,WM_NOTIFY,0,0);
			}
	}
	else
	{
		Usage(currWindow, "\00314/\00315window \00314<\00315new\00314> [\00315name\00314]");
		Usage(currWindow, "\00314/\00315window \00314<\00315list\00314>");
		Usage(currWindow, "\00314/\00315window \00314<\00315name\00314>");
		Usage(currWindow, "\00314/\00315window \00314<\00315close\00314>");
	}
}

void Quote(char *args)
{
	if (args)
	{
		Send(windows[currWindow].sock, "%s\r\n", args);
	} else
		Usage(currWindow, "\00314/\00315quote \00314<\00315raw command\00314>");
}

void Away(char *args)
{
	channelType *chan;
	char *reason = strtok(args, "");
	char noreason[12] = "(no reason)";

	if (windows[currWindow].setAway==0)
	{
		if (reason==NULL) reason=&noreason;
		Put(currWindow, "%s%s is away\002:\002 %s \002[\002l\002(\002on\002)\002 p\002(\002on\002)]\002\n", header, windows[currWindow].nick, reason);
		for (chan = windows[currWindow].channels; chan; chan = chan->next)
		{
			Send(windows[currWindow].sock, "PRIVMSG %s :\001ACTION is away\002:\002 %s \002[\002l\002(\002on\002)\002 p\002(\002on\002)]\002\001\r\n", chan->name, reason);
		}
		Send(windows[currWindow].sock, "AWAY :%s\r\n", reason);
		windows[currWindow].setAway = time(0);
	} else {
		int mins, secs;

		secs = (time(0) - windows[currWindow].setAway);
		mins = secs / 60;
		secs = secs % 60;
		Put(currWindow, "%s%s is back \002[\002gone\002(\002%dm %ds\002)]\002\n", header, windows[currWindow].nick, mins, secs);
		for (chan = windows[currWindow].channels; chan; chan = chan->next)
		{
			Send(windows[currWindow].sock, "PRIVMSG %s :\001ACTION is back \002[\002gone\002(\002%dm %ds\002)]\002\r\n", chan->name, mins, secs);
		}
		Send(windows[currWindow].sock, "AWAY\r\n");
		windows[currWindow].setAway = 0;
	}
}

void Notice(char *args)
{
	char *a, *b;
	a = strtok(args, " ");
	b = strtok(NULL, "");
	if (a && b)
	{
		Send(windows[currWindow].sock, "NOTICE %s :%s\r\n", a, b);
		Put(currWindow, "%s\00314[\0030n\00315otice\00314(\00315%s\00314)]\00315 %s\00315\n", header, a, b);
	} else
		Usage(currWindow,"\00314/\00315notice \00314<\00315nick\00314|\00315#channel\00314> <\00315text\00314>");
}

//void NsLookup(char *args)
//{
//	char *host = strtok(args, " ");
//	if (host)
//	{
//		long addr = inet_addr(host);
//		if (addr == -1)
//			WSAAsyncGetHostByName(hMainWnd, WM_USER+0x2001, host, (char *)windows[currWindow].nslookup, sizeof(windows[currWindow].nslookup));
//		else
//			WSAAsyncGetHostByAddr(hMainWnd, WM_USER+0x2001, (char *)htonl(addr), sizeof(long), 0, (char *)windows[currWindow].nslookup, sizeof(windows[currWindow].nslookup));
//	} else
//		Usage(currWindow, "\00314/\00315nslookup \00314<\00315host\00314|\00315ip address\00314>");
//}

void Sv(char *args)
{
	OSVERSIONINFO os;
	char *flavor = "", vers[512], *dest;

	dest = strtok(args, "");
	os.dwOSVersionInfoSize = sizeof(os);
	GetVersionEx(&os);
	if (os.dwPlatformId == VER_PLATFORM_WIN32s) flavor = "32s";
	else if (os.dwPlatformId == VER_PLATFORM_WIN32_NT)
	{
		if ((os.dwMajorVersion==5)&&(os.dwMinorVersion==0)) flavor = "2000";
		else if ((os.dwMajorVersion==5)&&(os.dwMinorVersion==1)) flavor = "XP";
		else flavor = "NT";
	}
	else if (os.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS && os.dwMinorVersion == 0) flavor = "95";
	else if (os.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS && os.dwMinorVersion > 0) flavor = "98";
	ZeroMemory(&vers, sizeof(vers));
	if (dest) 
	{
		strcpy(vers, dest);
		strcat(vers, " ");
	}
	strcat(vers, cvt_style("VERSION", "%s %s %d %d %d", version, flavor, os.dwMajorVersion, os.dwMinorVersion, os.dwPlatformId == VER_PLATFORM_WIN32_NT?os.dwBuildNumber:LOWORD(os.dwBuildNumber)));
	if (dest) Msg(vers); else Sayit(vers);
}

void Sayit(char *args)
{
	char *text = strtok(args, "");

	if (text)
	{
		if (windows[currWindow].cchan)
		{
			Put(currWindow, "\00314<\00315%s\00314>\00315 %s\n", windows[currWindow].nick, text);
			Send(windows[currWindow].sock, "PRIVMSG %s :%s\r\n", windows[currWindow].cchan->name, text);
		} else
			Put(currWindow, "%s You are not on any channels\n", header);
	}
}

void Style(char *args)
{
	char *fname = strtok(args, "");
	HANDLE hf;
	char buf[8192], ch, *cmd, *ident, *data;
	int num, pos = 0, i, cnt = 0;

	if (fname)
	{
		hf = CreateFile(fname, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_ALWAYS,
			FILE_ATTRIBUTE_NORMAL, NULL);
		ZeroMemory(&buf, sizeof(buf));
		while (ReadFile(hf, &ch, 1, &num, NULL))
		{
			if (num == 0) break;
			if (ch == '\n')
			{
				cmd = strtok(buf, " ");
				if (!strcmpi(cmd, "set"))
				{
					ident = strtok(NULL, " ");
					data = strtok(NULL, "");
									
					if (ident && data)
					{
						for (i = 0; styles[i].identifier; i++)
						{
							if (!strcmpi(styles[i].identifier, ident))
							{
								free(styles[i].data);
								styles[i].data = (char *)malloc(lstrlen(data) + 1);
								strcpy(styles[i].data, data);
								cnt++;
							}
						}
					}
				}
				ZeroMemory(&buf, sizeof(buf));
				pos = 0;
			} else 
			if (ch != '\r')
			{
				buf[pos] = ch;
				pos++;
			}
		}
		CloseHandle(hf);
		Put(currWindow, "%s Loaded %d styles from %s\n", header, cnt, fname);
	} else
		Usage(currWindow, "\00314/\00315style \00314<\00315file\00314>");
}

void Clear(char *args)
{
		SendMessage(windows[currWindow].hEdit, WM_SETTEXT, 0, 0);
		UpdateWindow(windows[currWindow].hEdit);
}

void About(char *args)
{
	Put(currWindow, "%s\n", header);
	Put(currWindow, "%s \002%s-%s\002 build %s\n", header, ircname, version, builddate);
//	Put(currWindow, "%s compiled on %s at %s\n", header, __DATE__, __TIME__);
	Put(currWindow, "%s %s \00314[\00315%s\00314]\00315\n", header, copyright, mail);
	Put(currWindow, "%s Homepage %s\n", header, homepage);
	Put(currWindow, "%s\n", header);
}

void CmdConnect(char *args)
{
	Server(cfg.server);
}

void CmdDisconnect(char *args)
{
	if (windows[currWindow].loggedIn) {
		closesocket(windows[currWindow].sock);
		windows[currWindow].sock = INVALID_SOCKET;
		ZeroMemory(&windows[currWindow].buf, sizeof(windows[currWindow].buf));
		ZeroMemory(&windows[numWindows].last_invite, sizeof(windows[numWindows].last_invite));
		windows[currWindow].bufpos = 0;
		windows[currWindow].lag = 0;
		windows[currWindow].cchan = NULL;
		windows[currWindow].loggedIn = FALSE;
		windows[currWindow].idle = 0;
		windows[currWindow].setAway = 0;
		DestroyChannels(currWindow);
		Put(currWindow, "%s\00314[\0030d\00315isconnect\00314/\00315%s\00314(\00315%d\00314)]\00315\n", header, windows[currWindow].currServer, windows[currWindow].currPort);	StopIdentd();
	} else {
		Put(currWindow, "%s\00314[\0030d\00315isconnect\00314/\00315you're not logged in!\00314]\00315\n", header);
	}
}

#ifndef DLL
void CmdConfig(char *args)
{
	_beginthread(CreatePropertySheet, 0, hMainWnd);
}
#endif

void CmdFinger(char *args)
{
//	Put(currWindow, "%s no finger available...\n", header);
//	char Text[200];
	char *a, *b;
	struct hostent *hp;
	struct sockaddr_in sin;
	SOCKET s;

//	GetDlgItemText(hwnd, IDC_FINGER_USER, Text, sizeof(Text) - 1);

//	a = strtok(Text, "@");
//	b = strtok(NULL, "");
	a = strtok(args, "@");
	b = strtok(NULL, "");

//	if (strcmp(Text, "") == 0 || b == NULL)
	if (strcmp(args, "") == 0 || b == NULL)
	{
		Usage(currWindow, "\00314/\00315finger \00314<\00315user@host\00314>");
//		Put(currWindow,"%s\00314[\0030f\00315inger\00314/\00315You must specify a proper user and host.\00314]\00315\n",header);
		return;
	}

	//MessageBox(hwnd, a, b, MB_OK);
	
	ZeroMemory(&sin, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = htons(79);
	sin.sin_addr.s_addr = inet_addr(b);
	if (sin.sin_addr.s_addr == INADDR_NONE)
	{
		hp = gethostbyname(b);
		if (hp == NULL)
		{
			Put(currWindow,"%s\00314[\0030f\00315inger\00314/\00315Could not resolve...\00314]\00315\n",header);
			return;
		}
		memcpy(&sin.sin_addr, hp->h_addr_list[0], sizeof(DWORD));
	}
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s == INVALID_SOCKET) return;
	if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) != SOCKET_ERROR) 
	{
		Send(s, "%s\r\n", a);
		WSAAsyncSelect(s, hMainWnd, WM_USER+0x2002, FD_CLOSE | FD_READ);
		return;
	}
	Put(currWindow,"%s\00314[\0030f\00315inger\00314/\00315Could not connect to %s\00314]\00315\n",header,b);
	return;
}

void CmdLog(char *args)
{
//	Put(currWindow, "%s no logging available...\n", header);
	if (windows[currWindow].logfilename[0]=='\0') {
		if (stricmp(args,"")) {
			Put(currWindow,"%s\00314[\0030l\00315ogging\00314/\00315Logging to file %s\00314]\00315\n",header,args);
			strcpy(windows[currWindow].logfilename, args);
		} else {
			Usage(currWindow, "\00314/\00315log \00314<\00315path\\logfile.log\00314>");
		}
	} else {
		ZeroMemory(&windows[currWindow].logfilename, sizeof(windows[currWindow].logfilename));
		Put(currWindow,"%s\00314[\0030l\00315ogging\00314/\00315Logging disabled.\00314]\00315\n",header);
	}
}

#ifndef DLL
void CmdTray(char *args)
{
	NOTIFYICONDATA icondata;

	icondata.cbSize =sizeof(NOTIFYICONDATA);
	icondata.hWnd   =hMainWnd;
	icondata.uID    =1;
	icondata.uFlags =NIF_MESSAGE | NIF_ICON | NIF_TIP;
	icondata.hIcon  =LoadIcon(g_hInst,(const char *)IDI_0IRC_SMALL);
	icondata.uCallbackMessage = CM_TRAYICON;
	strcpy(icondata.szTip,ircname);
	strcat(icondata.szTip," ");
	strcat(icondata.szTip,version);
	if ((windows[currWindow].cchan)&&(windows[currWindow].channels)) {
		strcat(icondata.szTip," - ");
		strcat(icondata.szTip,windows[currWindow].cchan->name);
	}

	Shell_NotifyIcon(NIM_ADD, &icondata);
	ShowWindow(hMainWnd,SW_HIDE);
	isTray=TRUE;
}
#endif
